package com.amity.socialcloud.sdk.video.domain.room

import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.amity.socialcloud.sdk.model.video.room.AmityRoomBroadcastData
import com.amity.socialcloud.sdk.model.video.room.AmityRoomType
import io.reactivex.rxjava3.core.Single

internal class GetBroadcasterDataUseCase {
    fun execute(roomId: String): Single<AmityRoomBroadcastData> {
        return RoomRepository().getBroadcasterData(roomId)
            .map { dto ->
                when (dto.type) {
                    AmityRoomType.DIRECT_STREAMING.apiKey -> {
                        AmityRoomBroadcastData.DirectStreaming(
                            directStreamUrl = dto.directStreamUrl ?: ""
                        )
                    }
                    AmityRoomType.CO_HOSTS.apiKey -> {
                        AmityRoomBroadcastData.CoHosts(
                            coHostToken = dto.coHostToken ?: "",
                            coHostUrl = dto.coHostUrl ?: ""
                        )
                    }
                    else -> {
                        // Default to CoHosts if type is unknown
                        AmityRoomBroadcastData.CoHosts(
                            coHostToken = dto.coHostToken ?: "",
                            coHostUrl = dto.coHostUrl ?: ""
                        )
                    }
                }
            }
    }
}

