package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import com.amity.socialcloud.sdk.dto.social.story.StoryTargetDto
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetLocalDataStore


internal class StoryCreated : StoryEventListner() {

    override fun getEventName(): String {
        return "story.created"
    }

    override fun shouldProcessEvent(dto: StoryQueryDto): Boolean {
        return true
    }

    override fun processEvent(dto: StoryQueryDto) {
        dto.storyTargets = dto.stories?.map {
            val targetDto =  StoryTargetDto(
                targetType = it.targetType,
                targetId = it.targetId,
                targetPublicId = it.targetPublicId,
                lastStoryExpiresAt = it.expiresAt,
                lastStorySeenExpiresAt = null,
                targetUpdatedAt = it.updatedAt
            )
            val cacheStoryTarget = StoryTargetLocalDataStore().getStoryTarget(
                targetType = AmityStory.TargetType.enumOf(it.targetType),
                targetId = it.targetId ?: ""
            )
            if(cacheStoryTarget != null) {
                targetDto.lastStorySeenExpiresAt = cacheStoryTarget.localLastStorySeenExpiresAt
            }
            targetDto
        }
        super.processEvent(dto)
    }

}