package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.ObjectResolverEngine
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto

internal class ChannelMemberAdded : ChannelEventListener() {

    override fun getEventName(): String {
        return "channel.membersAdded"
    }
    
    override fun processEvent(dto: ChannelEventDto) {
        if (super.shouldProcessEvent(dto)) {
            super.processEvent(dto)
        } else {
            // Resolve channel object when active user is added to the channel
            // but the channel is not in cache
            val repository = ChannelRepository()
            dto.channelDtoList
                .map { it.channelId }
                .filter { it.isNotEmpty() && !repository.isChannelCacheExists(it) }
                .let { channelIds ->
                    if (channelIds.isNotEmpty()) {
                        CoreClient.resolve(channelIds, ObjectResolverEngine.Companion.ReferenceType.CHANNEL)
                    }
                }
        }
    }
    
    override fun shouldProcessEvent(dto: ChannelEventDto): Boolean {
        return super.shouldProcessEvent(dto) || isActiveUserAddedEvent(dto)
    }

}