package com.amity.socialcloud.sdk.core.data.settings.network

import com.amity.socialcloud.sdk.core.data.settings.network.core.user.UserSettingsDto
import com.amity.socialcloud.sdk.core.data.settings.network.moderation.ValidateTextsRequest
import com.amity.socialcloud.sdk.core.data.settings.network.moderation.ValidateUrlsRequest
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.ChatSettingsDto
import com.ekoapp.ekosdk.internal.api.dto.SocialNetworkSettingsDto
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class NetworkSettingsRemoteDataStore {

    fun getChatSettings(): Single<ChatSettingsDto> {
        return AmityHttpClient.get(NetworkSettingsApi::class).flatMap {
            it.getChatSettings()
        }
    }

    fun getSocialSettings(): Single<SocialNetworkSettingsDto> {
        return AmityHttpClient.get(NetworkSettingsApi::class).flatMap {
            it.getSocialSettings()
        }
    }

    fun getCoreUserSettings(): Single<UserSettingsDto> {
        return AmityHttpClient.get(NetworkSettingsApi::class).flatMap {
            it.getCoreUserSettings()
        }
    }

    fun validateUrls(urls: List<String>): Completable {
        return Single.fromCallable {
            ValidateUrlsRequest(urls)
        }.flatMapCompletable { request ->
            AmityHttpClient.get(NetworkSettingsApi::class).flatMap {
                it.validateUrls(request)
            }.ignoreElement()
        }
    }

    fun validateTexts(texts: List<String>): Completable {
        return Single.fromCallable {
            ValidateTextsRequest(texts)
        }.flatMapCompletable { request ->
            AmityHttpClient.get(NetworkSettingsApi::class).flatMap {
                it.validateTexts(request)
            }.ignoreElement()
        }
    }

}