/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.user;

import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomRawQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.core.data.user.UserDao;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.model.core.role.AmityRoles;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import org.joda.time.DateTime;

public final class UserDao_Impl
extends UserDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<UserEntity> __insertAdapterOfUserEntity;
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<UserEntity> __deleteAdapterOfUserEntity;
    private final EntityDeleteOrUpdateAdapter<UserEntity> __updateAdapterOfUserEntity;

    public UserDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfUserEntity = new EntityInsertAdapter<UserEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `user` (`userId`,`mid`,`path`,`displayName`,`roles`,`permissions`,`flagCount`,`metadata`,`avatarFileId`,`avatarCustomUrl`,`description`,`isGlobalBan`,`isDeleted`,`isBrand`,`lastHeartbeat`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                if (entity.getMid() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMid());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getDisplayName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDisplayName());
                }
                String _tmp = UserDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(entity.getRoles());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = UserDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(entity.getPermissions());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                statement.bindLong(7, (long)entity.getFlagCount());
                String _tmp_2 = UserDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getAvatarFileId());
                }
                if (entity.getAvatarCustomUrl() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getAvatarCustomUrl());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getDescription());
                }
                int _tmp_3 = entity.isGlobalBan() ? 1 : 0;
                statement.bindLong(12, (long)_tmp_3);
                int _tmp_4 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_4);
                int _tmp_5 = entity.isBrand() ? 1 : 0;
                statement.bindLong(14, (long)_tmp_5);
                String _tmp_6 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastHeartbeat());
                if (_tmp_6 == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, _tmp_6);
                }
                String _tmp_7 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, _tmp_7);
                }
                String _tmp_8 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_8 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, _tmp_8);
                }
                String _tmp_9 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_9 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_9);
                }
            }
        };
        this.__deleteAdapterOfUserEntity = new EntityDeleteOrUpdateAdapter<UserEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `user` WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfUserEntity = new EntityDeleteOrUpdateAdapter<UserEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `user` SET `userId` = ?,`mid` = ?,`path` = ?,`displayName` = ?,`roles` = ?,`permissions` = ?,`flagCount` = ?,`metadata` = ?,`avatarFileId` = ?,`avatarCustomUrl` = ?,`description` = ?,`isGlobalBan` = ?,`isDeleted` = ?,`isBrand` = ?,`lastHeartbeat` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                if (entity.getMid() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMid());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getDisplayName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDisplayName());
                }
                String _tmp = UserDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(entity.getRoles());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = UserDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(entity.getPermissions());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                statement.bindLong(7, (long)entity.getFlagCount());
                String _tmp_2 = UserDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getAvatarFileId());
                }
                if (entity.getAvatarCustomUrl() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getAvatarCustomUrl());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getDescription());
                }
                int _tmp_3 = entity.isGlobalBan() ? 1 : 0;
                statement.bindLong(12, (long)_tmp_3);
                int _tmp_4 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_4);
                int _tmp_5 = entity.isBrand() ? 1 : 0;
                statement.bindLong(14, (long)_tmp_5);
                String _tmp_6 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastHeartbeat());
                if (_tmp_6 == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, _tmp_6);
                }
                String _tmp_7 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, _tmp_7);
                }
                String _tmp_8 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_8 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, _tmp_8);
                }
                String _tmp_9 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_9 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_9);
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(UserEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends UserEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(UserEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends UserEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(UserEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfUserEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(UserEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends UserEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(UserEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    PagingSource<Integer, UserEntity> getPagingSourceImpl(final String keyword, final String sortBy) {
        String _sql = "SELECT * from user, user_query_token where (user.displayName like '%' || ? || '%' or user.userId like '%' || ? || '%') and (user_query_token.keyword = ? and user_query_token.sortBy = ? and user_query_token.ids like '%' || user.userId || '%') order by user.displayName asc";
        RoomRawQuery _rawQuery = new RoomRawQuery("SELECT * from user, user_query_token where (user.displayName like '%' || ? || '%' or user.userId like '%' || ? || '%') and (user_query_token.keyword = ? and user_query_token.sortBy = ? and user_query_token.ids like '%' || user.userId || '%') order by user.displayName asc", (Function1)new Function1<SQLiteStatement, Unit>(){

            @NonNull
            public Unit invoke(@NonNull SQLiteStatement _stmt) {
                int _argIndex = 1;
                if (keyword == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, keyword);
                }
                _argIndex = 2;
                if (keyword == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, keyword);
                }
                _argIndex = 3;
                if (keyword == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, keyword);
                }
                _argIndex = 4;
                if (sortBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sortBy);
                }
                return Unit.INSTANCE;
            }
        });
        return new LimitOffsetPagingSource<UserEntity>(_rawQuery, this.__db, new String[]{"user", "user_query_token"}){

            protected Object convertRows(RoomRawQuery limitOffsetQuery, int itemCount, Continuation<? super List<? extends UserEntity>> $completion) {
                return DBUtil.performSuspending((RoomDatabase)UserDao_Impl.this.__db, (boolean)true, (boolean)false, _connection -> {
                    SQLiteStatement _stmt = _connection.prepare(limitOffsetQuery.getSql());
                    limitOffsetQuery.getBindingFunction().invoke((Object)_stmt);
                    try {
                        int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                        int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                        int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                        int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                        int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                        int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                        int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                        int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                        int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                        int _columnIndexOfAvatarCustomUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarCustomUrl");
                        int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                        int _columnIndexOfIsGlobalBan = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isGlobalBan");
                        int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                        int _columnIndexOfIsBrand = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBrand");
                        int _columnIndexOfLastHeartbeat = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastHeartbeat");
                        int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                        int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                        int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                        ArrayList<UserEntity> _result = new ArrayList<UserEntity>();
                        while (_stmt.step()) {
                            String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                            String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                            String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                            String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                            String _tmp = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                            AmityRoles _tmpRoles = UserDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                            String _tmp_1 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                            AmityPermissions _tmpPermissions = UserDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                            int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                            String _tmp_2 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                            JsonObject _tmpMetadata = UserDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                            String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                            String _tmpAvatarCustomUrl = _stmt.isNull(_columnIndexOfAvatarCustomUrl) ? null : _stmt.getText(_columnIndexOfAvatarCustomUrl);
                            String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                            int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsGlobalBan);
                            boolean _tmpIsGlobalBan = _tmp_3 != 0;
                            int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_4 != 0;
                            int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsBrand);
                            boolean _tmpIsBrand = _tmp_5 != 0;
                            String _tmp_6 = _stmt.isNull(_columnIndexOfLastHeartbeat) ? null : _stmt.getText(_columnIndexOfLastHeartbeat);
                            DateTime _tmpLastHeartbeat = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            UserEntity _item = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                            String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setExpiresAt(_tmpExpiresAt);
                            _result.add(_item);
                        }
                        ArrayList<UserEntity> arrayList = _result;
                        return arrayList;
                    }
                    finally {
                        _stmt.close();
                    }
                }, $completion);
            }
        };
    }

    @Override
    Flowable<UserEntity> getByIdImpl(String userId) {
        String _sql = "SELECT * from user where user.userId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user where user.userId = ? LIMIT 1");){
                UserEntity _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfAvatarCustomUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarCustomUrl");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfIsGlobalBan = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isGlobalBan");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfIsBrand = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBrand");
                int _columnIndexOfLastHeartbeat = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastHeartbeat");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    String _tmp = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    String _tmpAvatarCustomUrl = _stmt.isNull(_columnIndexOfAvatarCustomUrl) ? null : _stmt.getText(_columnIndexOfAvatarCustomUrl);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsGlobalBan);
                    boolean _tmpIsGlobalBan = _tmp_3 != 0;
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsBrand);
                    boolean _tmpIsBrand = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLastHeartbeat) ? null : _stmt.getText(_columnIndexOfLastHeartbeat);
                    DateTime _tmpLastHeartbeat = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                UserEntity userEntity = _result;
                return userEntity;
            }
        });
    }

    @Override
    Flowable<List<UserEntity>> observeUserImpl(String userId) {
        String _sql = "SELECT * from user where user.userId IN (?)";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user where user.userId IN (?)");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfAvatarCustomUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarCustomUrl");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfIsGlobalBan = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isGlobalBan");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfIsBrand = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBrand");
                int _columnIndexOfLastHeartbeat = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastHeartbeat");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<UserEntity> _result = new ArrayList<UserEntity>();
                while (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    String _tmp = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    String _tmpAvatarCustomUrl = _stmt.isNull(_columnIndexOfAvatarCustomUrl) ? null : _stmt.getText(_columnIndexOfAvatarCustomUrl);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsGlobalBan);
                    boolean _tmpIsGlobalBan = _tmp_3 != 0;
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsBrand);
                    boolean _tmpIsBrand = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLastHeartbeat) ? null : _stmt.getText(_columnIndexOfLastHeartbeat);
                    DateTime _tmpLastHeartbeat = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    UserEntity _item = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<UserEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    UserEntity getByIdNowImpl(String userId) {
        String _sql = "SELECT * from user where user.userId = ? LIMIT 1";
        return (UserEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user where user.userId = ? LIMIT 1");){
                UserEntity _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfAvatarCustomUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarCustomUrl");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfIsGlobalBan = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isGlobalBan");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfIsBrand = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBrand");
                int _columnIndexOfLastHeartbeat = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastHeartbeat");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    String _tmp = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    String _tmpAvatarCustomUrl = _stmt.isNull(_columnIndexOfAvatarCustomUrl) ? null : _stmt.getText(_columnIndexOfAvatarCustomUrl);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsGlobalBan);
                    boolean _tmpIsGlobalBan = _tmp_3 != 0;
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsBrand);
                    boolean _tmpIsBrand = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLastHeartbeat) ? null : _stmt.getText(_columnIndexOfLastHeartbeat);
                    DateTime _tmpLastHeartbeat = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                UserEntity userEntity = _result;
                return userEntity;
            }
        });
    }

    @Override
    List<UserEntity> getByIdsNowImpl(List<String> userIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from user where user.userId IN (");
        int _inputSize = userIds == null ? 1 : userIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (userIds == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : userIds) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfAvatarCustomUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarCustomUrl");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfIsGlobalBan = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isGlobalBan");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfIsBrand = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBrand");
                int _columnIndexOfLastHeartbeat = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastHeartbeat");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<UserEntity> _result = new ArrayList<UserEntity>();
                while (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    String _tmp = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    String _tmpAvatarCustomUrl = _stmt.isNull(_columnIndexOfAvatarCustomUrl) ? null : _stmt.getText(_columnIndexOfAvatarCustomUrl);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsGlobalBan);
                    boolean _tmpIsGlobalBan = _tmp_3 != 0;
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsBrand);
                    boolean _tmpIsBrand = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLastHeartbeat) ? null : _stmt.getText(_columnIndexOfLastHeartbeat);
                    DateTime _tmpLastHeartbeat = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    UserEntity _item_1 = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<UserEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<List<UserEntity>> getByUserIdsImpl(List<String> userIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from user where user.userId IN (");
        int _inputSize = userIds == null ? 1 : userIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (userIds == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : userIds) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfAvatarCustomUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarCustomUrl");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfIsGlobalBan = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isGlobalBan");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfIsBrand = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBrand");
                int _columnIndexOfLastHeartbeat = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastHeartbeat");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<UserEntity> _result = new ArrayList<UserEntity>();
                while (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    String _tmp = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    String _tmpAvatarCustomUrl = _stmt.isNull(_columnIndexOfAvatarCustomUrl) ? null : _stmt.getText(_columnIndexOfAvatarCustomUrl);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsGlobalBan);
                    boolean _tmpIsGlobalBan = _tmp_3 != 0;
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsBrand);
                    boolean _tmpIsBrand = _tmp_5 != 0;
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLastHeartbeat) ? null : _stmt.getText(_columnIndexOfLastHeartbeat);
                    DateTime _tmpLastHeartbeat = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    UserEntity _item_1 = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<UserEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from user";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String userId) {
        String _sql = "DELETE from user where userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user where userId = ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

