package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Query
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class InvitationDao : EkoObjectDao<InvitationEntity>() {
    @Delete
    abstract override fun delete(invitation: InvitationEntity)

    @Query("DELETE from invitation")
    abstract override fun deleteAll()

    @Query("SELECT * FROM invitation WHERE targetId = :targetId")
    abstract fun getInvitation(targetId: String): InvitationEntity?

    @Query("SELECT * FROM invitation WHERE targetId = :targetId and targetType = :targetType and invitedUserId = :invitedUserId order by createdAt desc limit 1")
    abstract fun observeUserInvitation(targetId: String, targetType: String, invitedUserId: String): Flowable<InvitationEntity>

    @Query("SELECT * FROM invitation WHERE targetId = :targetId and targetType = :targetType order by createdAt desc")
    abstract fun observeInvitations(targetId: String, targetType: String): Flowable<List<InvitationEntity>>

    @Query("UPDATE invitation SET status = :status WHERE invitationId = :invitationId")
    abstract fun updateStatus(
        invitationId: String,
        status: String,
    ): Int

    @Query("SELECT * FROM invitation WHERE invitationId = :invitationId LIMIT 1")
    abstract fun getByIdNowImpl(invitationId: String): InvitationEntity

    override fun getByIdNow(id: String): InvitationEntity {
        return getByIdNowImpl(id)
    }
}
