package com.amity.socialcloud.sdk.social.domain.community

import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.entity.CommunityEntity
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class CommunityLiveObjectUseCase : LiveObjectUseCase<CommunityEntity, AmityCommunity>() {


    override fun createRepository(): AmityObjectRepository<CommunityEntity, AmityCommunity> =
        CommunityRepository()

    override fun composeModel(model: AmityCommunity): AmityCommunity =
        CommunityComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.COMMUNITY
}