package com.amity.socialcloud.sdk.social.data.community

import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.entity.DiscussionCommunityEntity
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class DiscussionCommunityLocalDataStore {

    fun getDiscussionCommunity(communityId: String): DiscussionCommunityEntity? {
        var community: DiscussionCommunityEntity? = null
        Completable.fromCallable {
            val discussionCommunityDao = UserDatabase.get().discussionCommunityDao()
            val entity = discussionCommunityDao.getByIdNow(communityId)
            if (entity != null) {
                community = entity
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return community
    }

    fun observeDiscussionCommunity(communityId: String): Flowable<DiscussionCommunityEntity> {
        return UserDatabase.get().discussionCommunityDao().getByCommunityId(communityId)
    }

    fun saveDiscussionCommunities(communities: List<DiscussionCommunityEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().discussionCommunityDao().save(communities) }
    }

    fun deleteDiscussionCommunity(communityId: String): Completable {
        return UserDatabase.get().discussionCommunityDao().deleteByCommunityId(communityId)
    }

    fun hasInLocal(communityId: String): Boolean {
        val discussionCommunityDao = UserDatabase.get().discussionCommunityDao()
        return discussionCommunityDao.getByIdNow(communityId) != null
    }

    fun notifyChanges(communityId: String) {
        UserDatabase.get().discussionCommunityDao().notifyChanges(communityId)
    }

}
