package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.session.eventbus.CoHostEventBus
import com.amity.socialcloud.sdk.core.session.model.AmityCoHostEvent
import com.ekoapp.ekosdk.internal.api.dto.InvitationsQueryDto
import com.ekoapp.ekosdk.internal.usecase.invitation.GetInvitationByIdUseCase
import io.reactivex.rxjava3.core.Single
import java.util.concurrent.TimeUnit

internal class RoomDidCohostInviteReject : InvitationEventListener() {

    override fun getEventName(): String {
        return "room.didCohostInviteReject"
    }

    override fun shouldProcessEvent(dto: InvitationsQueryDto): Boolean {
        return true
    }

    override fun processEvent(dto: InvitationsQueryDto) {
        super.processEvent(dto)
        dto.invitations
            .firstOrNull { it.targetType == "room" }
            ?.let { invitation ->
                val coHostUserId = invitation.invitedUserId
                val roomId = invitation.targetId
                if (coHostUserId != null && !roomId.isNullOrBlank()) {
                    Single.just(invitation.invitationId)
                        .delay(200, TimeUnit.MILLISECONDS)
                        .doOnSuccess { invitationId ->
                            GetInvitationByIdUseCase().execute(invitationId = invitationId)
                                ?.let { invitation ->
                                    CoHostEventBus.publish(
                                        event = AmityCoHostEvent.CoHostInviteRejected(
                                            invitationId = invitationId,
                                            invitation = invitation
                                        )
                                    )
                                }
                        }
                }
            }
    }

}