package com.amity.socialcloud.sdk.api.chat.subchannel.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.chat.domain.subchannel.SubChannelPagingDataUseCase
import com.amity.socialcloud.sdk.model.chat.subchannel.AmitySubChannel
import io.reactivex.rxjava3.core.Flowable

class AmitySubChannelQuery internal constructor(
    private val channelId: String,
    private val excludeMainSubChannel: Boolean,
    private val isDeleted: Boolean,
) {

    fun query(): Flowable<PagingData<AmitySubChannel>> {
        return SubChannelPagingDataUseCase().execute(
            channelId = channelId,
            excludeMainSubChannel = excludeMainSubChannel,
            isDeleted = isDeleted
        )
    }

    class Builder {
        private lateinit var channelId: String
        private var excludeDefaultSubChannel: Boolean = false
        private var isDeleted: Boolean = false

        fun channelId(channelId: String): Builder {
            return apply { this.channelId = channelId }
        }

        fun excludeMainSubChannel(excludeDefaultSubChannel: Boolean): Builder {
            return apply { this.excludeDefaultSubChannel = excludeDefaultSubChannel }
        }

        fun isDeleted(isDeleted: Boolean): Builder {
            return apply { this.isDeleted = isDeleted }
        }

        fun build(): AmitySubChannelQuery {
            return AmitySubChannelQuery(
                channelId = channelId,
                excludeMainSubChannel = excludeDefaultSubChannel,
                isDeleted = isDeleted
            )
        }
    }

}