/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityWithCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCategoryEntity;
import com.ekoapp.ekosdk.internal.entity.DiscussionCommunityEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;

@Dao
public abstract class EkoDiscussionCommunityDao
extends EkoObjectDao<DiscussionCommunityEntity> {
    private final EkoCommunityWithCategoryDao communityWithCategoryDao = UserDatabase.get().communityWithCategoryDao();

    @Override
    @Query(value="DELETE from discussion_community")
    public abstract void deleteAll();

    @Query(value="UPDATE discussion_community set isDeleted = 1 where communityId = :communityId")
    abstract Completable deleteByCommunityIdImpl(String var1);

    public Completable deleteByCommunityId(String communityId) {
        return this.deleteByCommunityIdImpl(communityId);
    }

    @Query(value="SELECT * from discussion_community where discussion_community.communityId = :communityId LIMIT 1")
    abstract Flowable<DiscussionCommunityEntity> getByCommunityIdImpl(String var1);

    public Flowable<DiscussionCommunityEntity> getByCommunityId(String communityId) {
        return this.getByCommunityIdImpl(communityId);
    }

    @Override
    @Transaction
    public void insert(DiscussionCommunityEntity community) {
        super.insert(community);
        EkoCategoryDao.update(community, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void insert(@NonNull List<? extends DiscussionCommunityEntity> communities) {
        super.insert(communities);
        EkoCategoryDao.update(communities, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void update(DiscussionCommunityEntity community) {
        super.update(community);
        EkoCategoryDao.update(community, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void update(@NonNull List<? extends DiscussionCommunityEntity> communities) {
        super.update(communities);
        EkoCategoryDao.update(communities, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Query(value="SELECT * from discussion_community where communityId = :communityId LIMIT 1")
    abstract DiscussionCommunityEntity getByIdNowImpl(String var1);

    @Override
    public DiscussionCommunityEntity getByIdNow(String communityId) {
        return this.getByIdNowImpl(communityId);
    }

    @Query(value="UPDATE discussion_community set communityId = :communityId where communityId = :communityId")
    public abstract void notifyChanges(String var1);
}

