/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.notificationtray;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.core.data.notificationtray.NotificationTrayLocalDataStore;
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTrayItemEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u000fJ\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/core/data/notificationtray/NotificationTrayLocalDataStore;", "", "<init>", "()V", "observe", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/entity/core/notificationtray/NotificationTrayItemEntity;", "notificationId", "", "getNotificationTrayItem", "saveNotificationTrayItems", "Lio/reactivex/rxjava3/core/Completable;", "items", "", "getNotificationTrayItemPagingSource", "Landroidx/paging/PagingSource;", "", "markSeen", "lastSeenAt", "Lorg/joda/time/DateTime;", "amity-sdk_release"})
public final class NotificationTrayLocalDataStore {
    @NotNull
    public final Flowable<NotificationTrayItemEntity> observe(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Flowable flowable = UserDatabase.get().notificationTrayItemDao().observeNotificationTrayItem(notificationId).map((Function)observe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @Nullable
    public final NotificationTrayItemEntity getNotificationTrayItem(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Ref.ObjectRef notificationTrayItem = new Ref.ObjectRef();
        Completable.fromCallable(() -> NotificationTrayLocalDataStore.getNotificationTrayItem$lambda$0(notificationId, notificationTrayItem)).subscribeOn(Schedulers.io()).blockingAwait();
        return (NotificationTrayItemEntity)notificationTrayItem.element;
    }

    @NotNull
    public final Completable saveNotificationTrayItems(@NotNull List<? extends NotificationTrayItemEntity> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Completable completable = Completable.fromAction(() -> NotificationTrayLocalDataStore.saveNotificationTrayItems$lambda$1(items));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final PagingSource<Integer, NotificationTrayItemEntity> getNotificationTrayItemPagingSource() {
        return UserDatabase.get().notificationTrayItemPagingDao().queryNotificationTrayItems();
    }

    @NotNull
    public final Completable markSeen(@NotNull String notificationId, @NotNull DateTime lastSeenAt) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)lastSeenAt, (String)"lastSeenAt");
        Completable completable = Completable.fromAction(() -> NotificationTrayLocalDataStore.markSeen$lambda$2(notificationId, lastSeenAt));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    private static final Unit getNotificationTrayItem$lambda$0(String $notificationId, Ref.ObjectRef $notificationTrayItem) {
        NotificationTrayItemEntity notiItem = UserDatabase.get().notificationTrayItemDao().getByIdNow($notificationId);
        if (notiItem != null) {
            $notificationTrayItem.element = notiItem;
        }
        return Unit.INSTANCE;
    }

    private static final void saveNotificationTrayItems$lambda$1(List $items) {
        UserDatabase.get().notificationTrayItemDao().save($items);
    }

    private static final void markSeen$lambda$2(String $notificationId, DateTime $lastSeenAt) {
        NotificationTrayItemEntity currentSeen;
        NotificationTrayItemEntity notificationTrayItemEntity = currentSeen = UserDatabase.get().notificationTrayItemDao().getByIdNow($notificationId);
        if ((notificationTrayItemEntity != null ? notificationTrayItemEntity.getLastSeenAt() : null) == null || $lastSeenAt.isAfter((ReadableInstant)currentSeen.getLastSeenAt())) {
            UserDatabase.get().notificationTrayItemDao().markAsSeen($notificationId, $lastSeenAt);
        }
    }
}

