/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.room;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity;
import com.amity.socialcloud.sdk.video.data.room.RoomDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class RoomDao_Impl
extends RoomDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<RoomEntity> __insertionAdapterOfRoomEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EntityDeletionOrUpdateAdapter<RoomEntity> __deletionAdapterOfRoomEntity;
    private final EntityDeletionOrUpdateAdapter<RoomEntity> __updateAdapterOfRoomEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfUpdateRoomImpl;

    public RoomDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfRoomEntity = new EntityInsertionAdapter<RoomEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `room` (`roomId`,`type`,`targetType`,`targetId`,`referenceType`,`referenceId`,`channelEnabled`,`channelId`,`title`,`description`,`thumbnailFileId`,`status`,`participants`,`livePlaybackUrl`,`durationSeconds`,`parentRoomId`,`childRoomIds`,`creatorId`,`isDeleted`,`deletedAt`,`deletedById`,`metadata`,`liveAt`,`endedAt`,`recordedAt`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, RoomEntity value) {
                if (value.getRoomId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getRoomId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getType());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTargetId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getReferenceId());
                }
                int _tmp = value.getChannelEnabled() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp);
                if (value.getChannelId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getChannelId());
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getTitle());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getDescription());
                }
                if (value.getThumbnailFileId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getThumbnailFileId());
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getStatus());
                }
                String _tmp_1 = RoomDao_Impl.this.__stringListConverter.stringListToString(value.getParticipants());
                if (_tmp_1 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_1);
                }
                if (value.getLivePlaybackUrl() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getLivePlaybackUrl());
                }
                if (value.getDurationSeconds() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)value.getDurationSeconds().intValue());
                }
                if (value.getParentRoomId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getParentRoomId());
                }
                String _tmp_2 = RoomDao_Impl.this.__stringListConverter.stringListToString(value.getChildRoomIds());
                if (_tmp_2 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_2);
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getCreatorId());
                }
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(19, (long)_tmp_3);
                String _tmp_4 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getDeletedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_4);
                }
                if (value.getDeletedById() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.getDeletedById());
                }
                String _tmp_5 = RoomDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_5 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_5);
                }
                String _tmp_6 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLiveAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_6);
                }
                String _tmp_7 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEndedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_7);
                }
                String _tmp_8 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getRecordedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, _tmp_8);
                }
                String _tmp_9 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindString(26, _tmp_9);
                }
                String _tmp_10 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_10 == null) {
                    stmt.bindNull(27);
                } else {
                    stmt.bindString(27, _tmp_10);
                }
                String _tmp_11 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_11 == null) {
                    stmt.bindNull(28);
                } else {
                    stmt.bindString(28, _tmp_11);
                }
            }
        };
        this.__deletionAdapterOfRoomEntity = new EntityDeletionOrUpdateAdapter<RoomEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `room` WHERE `roomId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RoomEntity value) {
                if (value.getRoomId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getRoomId());
                }
            }
        };
        this.__updateAdapterOfRoomEntity = new EntityDeletionOrUpdateAdapter<RoomEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `room` SET `roomId` = ?,`type` = ?,`targetType` = ?,`targetId` = ?,`referenceType` = ?,`referenceId` = ?,`channelEnabled` = ?,`channelId` = ?,`title` = ?,`description` = ?,`thumbnailFileId` = ?,`status` = ?,`participants` = ?,`livePlaybackUrl` = ?,`durationSeconds` = ?,`parentRoomId` = ?,`childRoomIds` = ?,`creatorId` = ?,`isDeleted` = ?,`deletedAt` = ?,`deletedById` = ?,`metadata` = ?,`liveAt` = ?,`endedAt` = ?,`recordedAt` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `roomId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RoomEntity value) {
                if (value.getRoomId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getRoomId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getType());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTargetId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getReferenceId());
                }
                int _tmp = value.getChannelEnabled() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp);
                if (value.getChannelId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getChannelId());
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getTitle());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getDescription());
                }
                if (value.getThumbnailFileId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getThumbnailFileId());
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getStatus());
                }
                String _tmp_1 = RoomDao_Impl.this.__stringListConverter.stringListToString(value.getParticipants());
                if (_tmp_1 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_1);
                }
                if (value.getLivePlaybackUrl() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getLivePlaybackUrl());
                }
                if (value.getDurationSeconds() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)value.getDurationSeconds().intValue());
                }
                if (value.getParentRoomId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getParentRoomId());
                }
                String _tmp_2 = RoomDao_Impl.this.__stringListConverter.stringListToString(value.getChildRoomIds());
                if (_tmp_2 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_2);
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getCreatorId());
                }
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(19, (long)_tmp_3);
                String _tmp_4 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getDeletedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_4);
                }
                if (value.getDeletedById() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.getDeletedById());
                }
                String _tmp_5 = RoomDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_5 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_5);
                }
                String _tmp_6 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLiveAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_6);
                }
                String _tmp_7 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEndedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_7);
                }
                String _tmp_8 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getRecordedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, _tmp_8);
                }
                String _tmp_9 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindString(26, _tmp_9);
                }
                String _tmp_10 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_10 == null) {
                    stmt.bindNull(27);
                } else {
                    stmt.bindString(27, _tmp_10);
                }
                String _tmp_11 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_11 == null) {
                    stmt.bindNull(28);
                } else {
                    stmt.bindString(28, _tmp_11);
                }
                if (value.getRoomId() == null) {
                    stmt.bindNull(29);
                } else {
                    stmt.bindString(29, value.getRoomId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM room";
                return "DELETE FROM room";
            }
        };
        this.__preparedStmtOfUpdateRoomImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE room set roomId = ? where roomId = ?";
                return "UPDATE room set roomId = ? where roomId = ?";
            }
        };
    }

    @Override
    public void insertImpl(RoomEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRoomEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends RoomEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRoomEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(RoomEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfRoomEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends RoomEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfRoomEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(RoomEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfRoomEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(RoomEntity object) {
        this.__db.beginTransaction();
        try {
            RoomDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends RoomEntity> objects) {
        this.__db.beginTransaction();
        try {
            RoomDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(RoomEntity object) {
        this.__db.beginTransaction();
        try {
            RoomDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateRoom(String roomId) {
        this.__db.beginTransaction();
        try {
            RoomDao_Impl.super.updateRoom(roomId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRoomImpl(String roomId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateRoomImpl.acquire();
        int _argIndex = 1;
        if (roomId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, roomId);
        }
        _argIndex = 2;
        if (roomId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, roomId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateRoomImpl.release(_stmt);
        }
    }

    @Override
    public Flowable<RoomEntity> getByIdImpl(String roomId) {
        String _sql = "SELECT * FROM room WHERE roomId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM room WHERE roomId = ?", (int)1);
        int _argIndex = 1;
        if (roomId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, roomId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"room"}, (Callable)new Callable<RoomEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RoomEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)RoomDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    RoomEntity _result;
                    int _cursorIndexOfRoomId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfChannelEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelEnabled");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfThumbnailFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailFileId");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfParticipants = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"participants");
                    int _cursorIndexOfLivePlaybackUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"livePlaybackUrl");
                    int _cursorIndexOfDurationSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"durationSeconds");
                    int _cursorIndexOfParentRoomId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentRoomId");
                    int _cursorIndexOfChildRoomIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childRoomIds");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfDeletedById = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedById");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfLiveAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"liveAt");
                    int _cursorIndexOfEndedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"endedAt");
                    int _cursorIndexOfRecordedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recordedAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new RoomEntity();
                        String _tmpRoomId = _cursor.isNull(_cursorIndexOfRoomId) ? null : _cursor.getString(_cursorIndexOfRoomId);
                        _result.setRoomId(_tmpRoomId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        _result.setReferenceType(_tmpReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        _result.setReferenceId(_tmpReferenceId);
                        int _tmp = _cursor.getInt(_cursorIndexOfChannelEnabled);
                        boolean _tmpChannelEnabled = _tmp != 0;
                        _result.setChannelEnabled(_tmpChannelEnabled);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result.setDescription(_tmpDescription);
                        String _tmpThumbnailFileId = _cursor.isNull(_cursorIndexOfThumbnailFileId) ? null : _cursor.getString(_cursorIndexOfThumbnailFileId);
                        _result.setThumbnailFileId(_tmpThumbnailFileId);
                        String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                        _result.setStatus(_tmpStatus);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfParticipants) ? null : _cursor.getString(_cursorIndexOfParticipants);
                        List<String> _tmpParticipants = RoomDao_Impl.this.__stringListConverter.stringToStringList(_tmp_1);
                        _result.setParticipants(_tmpParticipants);
                        String _tmpLivePlaybackUrl = _cursor.isNull(_cursorIndexOfLivePlaybackUrl) ? null : _cursor.getString(_cursorIndexOfLivePlaybackUrl);
                        _result.setLivePlaybackUrl(_tmpLivePlaybackUrl);
                        Integer _tmpDurationSeconds = _cursor.isNull(_cursorIndexOfDurationSeconds) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDurationSeconds));
                        _result.setDurationSeconds(_tmpDurationSeconds);
                        String _tmpParentRoomId = _cursor.isNull(_cursorIndexOfParentRoomId) ? null : _cursor.getString(_cursorIndexOfParentRoomId);
                        _result.setParentRoomId(_tmpParentRoomId);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfChildRoomIds) ? null : _cursor.getString(_cursorIndexOfChildRoomIds);
                        List<String> _tmpChildRoomIds = RoomDao_Impl.this.__stringListConverter.stringToStringList(_tmp_2);
                        _result.setChildRoomIds(_tmpChildRoomIds);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        _result.setCreatorId(_tmpCreatorId);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_3 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : _cursor.getString(_cursorIndexOfDeletedAt);
                        DateTime _tmpDeletedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setDeletedAt(_tmpDeletedAt);
                        String _tmpDeletedById = _cursor.isNull(_cursorIndexOfDeletedById) ? null : _cursor.getString(_cursorIndexOfDeletedById);
                        _result.setDeletedById(_tmpDeletedById);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = RoomDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfLiveAt) ? null : _cursor.getString(_cursorIndexOfLiveAt);
                        DateTime _tmpLiveAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setLiveAt(_tmpLiveAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfEndedAt) ? null : _cursor.getString(_cursorIndexOfEndedAt);
                        DateTime _tmpEndedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setEndedAt(_tmpEndedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfRecordedAt) ? null : _cursor.getString(_cursorIndexOfRecordedAt);
                        DateTime _tmpRecordedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setRecordedAt(_tmpRecordedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    RoomEntity roomEntity = _result;
                    return roomEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoomEntity getByIdNowImpl(String roomId) {
        String _sql = "SELECT * FROM room WHERE roomId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM room WHERE roomId = ?", (int)1);
        int _argIndex = 1;
        if (roomId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, roomId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            RoomEntity _result;
            int _cursorIndexOfRoomId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomId");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfChannelEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelEnabled");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfThumbnailFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailFileId");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfParticipants = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"participants");
            int _cursorIndexOfLivePlaybackUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"livePlaybackUrl");
            int _cursorIndexOfDurationSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"durationSeconds");
            int _cursorIndexOfParentRoomId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentRoomId");
            int _cursorIndexOfChildRoomIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childRoomIds");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
            int _cursorIndexOfDeletedById = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedById");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfLiveAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"liveAt");
            int _cursorIndexOfEndedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"endedAt");
            int _cursorIndexOfRecordedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recordedAt");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new RoomEntity();
                String _tmpRoomId = _cursor.isNull(_cursorIndexOfRoomId) ? null : _cursor.getString(_cursorIndexOfRoomId);
                _result.setRoomId(_tmpRoomId);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _result.setType(_tmpType);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                _result.setReferenceType(_tmpReferenceType);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                _result.setReferenceId(_tmpReferenceId);
                int _tmp = _cursor.getInt(_cursorIndexOfChannelEnabled);
                boolean _tmpChannelEnabled = _tmp != 0;
                _result.setChannelEnabled(_tmpChannelEnabled);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                _result.setTitle(_tmpTitle);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                _result.setDescription(_tmpDescription);
                String _tmpThumbnailFileId = _cursor.isNull(_cursorIndexOfThumbnailFileId) ? null : _cursor.getString(_cursorIndexOfThumbnailFileId);
                _result.setThumbnailFileId(_tmpThumbnailFileId);
                String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                _result.setStatus(_tmpStatus);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfParticipants) ? null : _cursor.getString(_cursorIndexOfParticipants);
                List<String> _tmpParticipants = this.__stringListConverter.stringToStringList(_tmp_1);
                _result.setParticipants(_tmpParticipants);
                String _tmpLivePlaybackUrl = _cursor.isNull(_cursorIndexOfLivePlaybackUrl) ? null : _cursor.getString(_cursorIndexOfLivePlaybackUrl);
                _result.setLivePlaybackUrl(_tmpLivePlaybackUrl);
                Integer _tmpDurationSeconds = _cursor.isNull(_cursorIndexOfDurationSeconds) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDurationSeconds));
                _result.setDurationSeconds(_tmpDurationSeconds);
                String _tmpParentRoomId = _cursor.isNull(_cursorIndexOfParentRoomId) ? null : _cursor.getString(_cursorIndexOfParentRoomId);
                _result.setParentRoomId(_tmpParentRoomId);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfChildRoomIds) ? null : _cursor.getString(_cursorIndexOfChildRoomIds);
                List<String> _tmpChildRoomIds = this.__stringListConverter.stringToStringList(_tmp_2);
                _result.setChildRoomIds(_tmpChildRoomIds);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                _result.setCreatorId(_tmpCreatorId);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_3 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : _cursor.getString(_cursorIndexOfDeletedAt);
                DateTime _tmpDeletedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setDeletedAt(_tmpDeletedAt);
                String _tmpDeletedById = _cursor.isNull(_cursorIndexOfDeletedById) ? null : _cursor.getString(_cursorIndexOfDeletedById);
                _result.setDeletedById(_tmpDeletedById);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                _result.setMetadata(_tmpMetadata);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfLiveAt) ? null : _cursor.getString(_cursorIndexOfLiveAt);
                DateTime _tmpLiveAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setLiveAt(_tmpLiveAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfEndedAt) ? null : _cursor.getString(_cursorIndexOfEndedAt);
                DateTime _tmpEndedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setEndedAt(_tmpEndedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfRecordedAt) ? null : _cursor.getString(_cursorIndexOfRecordedAt);
                DateTime _tmpRecordedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setRecordedAt(_tmpRecordedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            RoomEntity roomEntity = _result;
            return roomEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RoomEntity> getByIdsNowImpl(List<String> roomIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM room WHERE roomId in (");
        int _inputSize = roomIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : roomIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfRoomId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomId");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfChannelEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelEnabled");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfThumbnailFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailFileId");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfParticipants = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"participants");
            int _cursorIndexOfLivePlaybackUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"livePlaybackUrl");
            int _cursorIndexOfDurationSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"durationSeconds");
            int _cursorIndexOfParentRoomId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentRoomId");
            int _cursorIndexOfChildRoomIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childRoomIds");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
            int _cursorIndexOfDeletedById = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedById");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfLiveAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"liveAt");
            int _cursorIndexOfEndedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"endedAt");
            int _cursorIndexOfRecordedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recordedAt");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<RoomEntity> _result = new ArrayList<RoomEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                RoomEntity _item_1 = new RoomEntity();
                String _tmpRoomId = _cursor.isNull(_cursorIndexOfRoomId) ? null : _cursor.getString(_cursorIndexOfRoomId);
                _item_1.setRoomId(_tmpRoomId);
                String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _item_1.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _item_1.setTargetId(_tmpTargetId);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                _item_1.setReferenceType(_tmpReferenceType);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                _item_1.setReferenceId(_tmpReferenceId);
                int _tmp = _cursor.getInt(_cursorIndexOfChannelEnabled);
                boolean _tmpChannelEnabled = _tmp != 0;
                _item_1.setChannelEnabled(_tmpChannelEnabled);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item_1.setChannelId(_tmpChannelId);
                String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                _item_1.setTitle(_tmpTitle);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                _item_1.setDescription(_tmpDescription);
                String _tmpThumbnailFileId = _cursor.isNull(_cursorIndexOfThumbnailFileId) ? null : _cursor.getString(_cursorIndexOfThumbnailFileId);
                _item_1.setThumbnailFileId(_tmpThumbnailFileId);
                String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                _item_1.setStatus(_tmpStatus);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfParticipants) ? null : _cursor.getString(_cursorIndexOfParticipants);
                List<String> _tmpParticipants = this.__stringListConverter.stringToStringList(_tmp_1);
                _item_1.setParticipants(_tmpParticipants);
                String _tmpLivePlaybackUrl = _cursor.isNull(_cursorIndexOfLivePlaybackUrl) ? null : _cursor.getString(_cursorIndexOfLivePlaybackUrl);
                _item_1.setLivePlaybackUrl(_tmpLivePlaybackUrl);
                Integer _tmpDurationSeconds = _cursor.isNull(_cursorIndexOfDurationSeconds) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDurationSeconds));
                _item_1.setDurationSeconds(_tmpDurationSeconds);
                String _tmpParentRoomId = _cursor.isNull(_cursorIndexOfParentRoomId) ? null : _cursor.getString(_cursorIndexOfParentRoomId);
                _item_1.setParentRoomId(_tmpParentRoomId);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfChildRoomIds) ? null : _cursor.getString(_cursorIndexOfChildRoomIds);
                List<String> _tmpChildRoomIds = this.__stringListConverter.stringToStringList(_tmp_2);
                _item_1.setChildRoomIds(_tmpChildRoomIds);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                _item_1.setCreatorId(_tmpCreatorId);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_3 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : _cursor.getString(_cursorIndexOfDeletedAt);
                DateTime _tmpDeletedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _item_1.setDeletedAt(_tmpDeletedAt);
                String _tmpDeletedById = _cursor.isNull(_cursorIndexOfDeletedById) ? null : _cursor.getString(_cursorIndexOfDeletedById);
                _item_1.setDeletedById(_tmpDeletedById);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                _item_1.setMetadata(_tmpMetadata);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfLiveAt) ? null : _cursor.getString(_cursorIndexOfLiveAt);
                DateTime _tmpLiveAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item_1.setLiveAt(_tmpLiveAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfEndedAt) ? null : _cursor.getString(_cursorIndexOfEndedAt);
                DateTime _tmpEndedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setEndedAt(_tmpEndedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfRecordedAt) ? null : _cursor.getString(_cursorIndexOfRecordedAt);
                DateTime _tmpRecordedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item_1.setRecordedAt(_tmpRecordedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<RoomEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<RoomEntity> getLatestRoomImpl(List<String> statuses, DateTime now) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM room WHERE status in (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AND room.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ORDER BY room.updatedAt DESC LIMIT 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : statuses) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"room"}, (Callable)new Callable<RoomEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RoomEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)RoomDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    RoomEntity _result;
                    int _cursorIndexOfRoomId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfChannelEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelEnabled");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfThumbnailFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailFileId");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfParticipants = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"participants");
                    int _cursorIndexOfLivePlaybackUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"livePlaybackUrl");
                    int _cursorIndexOfDurationSeconds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"durationSeconds");
                    int _cursorIndexOfParentRoomId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentRoomId");
                    int _cursorIndexOfChildRoomIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childRoomIds");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfDeletedById = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedById");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfLiveAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"liveAt");
                    int _cursorIndexOfEndedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"endedAt");
                    int _cursorIndexOfRecordedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recordedAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new RoomEntity();
                        String _tmpRoomId = _cursor.isNull(_cursorIndexOfRoomId) ? null : _cursor.getString(_cursorIndexOfRoomId);
                        _result.setRoomId(_tmpRoomId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        _result.setReferenceType(_tmpReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        _result.setReferenceId(_tmpReferenceId);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfChannelEnabled);
                        boolean _tmpChannelEnabled = _tmp_1 != 0;
                        _result.setChannelEnabled(_tmpChannelEnabled);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result.setDescription(_tmpDescription);
                        String _tmpThumbnailFileId = _cursor.isNull(_cursorIndexOfThumbnailFileId) ? null : _cursor.getString(_cursorIndexOfThumbnailFileId);
                        _result.setThumbnailFileId(_tmpThumbnailFileId);
                        String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                        _result.setStatus(_tmpStatus);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfParticipants) ? null : _cursor.getString(_cursorIndexOfParticipants);
                        List<String> _tmpParticipants = RoomDao_Impl.this.__stringListConverter.stringToStringList(_tmp_2);
                        _result.setParticipants(_tmpParticipants);
                        String _tmpLivePlaybackUrl = _cursor.isNull(_cursorIndexOfLivePlaybackUrl) ? null : _cursor.getString(_cursorIndexOfLivePlaybackUrl);
                        _result.setLivePlaybackUrl(_tmpLivePlaybackUrl);
                        Integer _tmpDurationSeconds = _cursor.isNull(_cursorIndexOfDurationSeconds) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDurationSeconds));
                        _result.setDurationSeconds(_tmpDurationSeconds);
                        String _tmpParentRoomId = _cursor.isNull(_cursorIndexOfParentRoomId) ? null : _cursor.getString(_cursorIndexOfParentRoomId);
                        _result.setParentRoomId(_tmpParentRoomId);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfChildRoomIds) ? null : _cursor.getString(_cursorIndexOfChildRoomIds);
                        List<String> _tmpChildRoomIds = RoomDao_Impl.this.__stringListConverter.stringToStringList(_tmp_3);
                        _result.setChildRoomIds(_tmpChildRoomIds);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        _result.setCreatorId(_tmpCreatorId);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_4 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : _cursor.getString(_cursorIndexOfDeletedAt);
                        DateTime _tmpDeletedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setDeletedAt(_tmpDeletedAt);
                        String _tmpDeletedById = _cursor.isNull(_cursorIndexOfDeletedById) ? null : _cursor.getString(_cursorIndexOfDeletedById);
                        _result.setDeletedById(_tmpDeletedById);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = RoomDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfLiveAt) ? null : _cursor.getString(_cursorIndexOfLiveAt);
                        DateTime _tmpLiveAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setLiveAt(_tmpLiveAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfEndedAt) ? null : _cursor.getString(_cursorIndexOfEndedAt);
                        DateTime _tmpEndedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setEndedAt(_tmpEndedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfRecordedAt) ? null : _cursor.getString(_cursorIndexOfRecordedAt);
                        DateTime _tmpRecordedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setRecordedAt(_tmpRecordedAt);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = RoomDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    RoomEntity roomEntity = _result;
                    return roomEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

