package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.entity.PollEntity
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class PollDao : EkoObjectDao<PollEntity>() {

    @Query("select * from poll where pollId = :pollId")
    abstract fun getPoll(pollId: String): Flowable<PollEntity>

    @Query("update poll set isDeleted = 1 where pollId = :pollId")
    abstract fun deletePoll(pollId: String): Completable

    @Query("delete from poll")
    abstract override fun deleteAll()

    @Query("select * from poll where pollId = :id limit 1")
    abstract fun getByIdNowImpl(id: String): PollEntity?

    override fun getByIdNow(id: String): PollEntity? {
        return getByIdNowImpl(id)
    }
}