package com.amity.socialcloud.sdk.social.data.community

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class CommunityJoinRequestDao : EkoObjectDao<JoinRequestEntity>() {

    // dummy update post
    @Query("UPDATE joinRequest set joinRequestId = joinRequestId where joinRequestId = :joinRequestId")
    abstract fun updateJoinRequestItem(joinRequestId: String)

    @Query(
        "SELECT *" +
                " from joinRequest" +
                " where joinRequestId = :joinRequestId"
    )
    abstract fun getByIdNowImpl(joinRequestId: String): JoinRequestEntity?
    override fun getByIdNow(joinRequestId: String): JoinRequestEntity? {
        return getByIdNowImpl(joinRequestId)
    }

    @Query(
        "SELECT *" +
                " from joinRequest" +
                " where joinRequest.joinRequestId in (:joinRequestIds)"
    )
    abstract fun observeByJoinRequestIdsImpl(joinRequestIds: List<String>): Flowable<List<JoinRequestEntity>>
    fun observeByJoinRequestIds(joinRequestIds: List<String>): Flowable<List<JoinRequestEntity>> {
        return observeByJoinRequestIdsImpl(joinRequestIds)
    }


    @Delete
    abstract override fun delete(joinRequest: JoinRequestEntity)

    @Query("UPDATE joinRequest SET status = :status WHERE targetId = :targetId AND userId = :userId")
    abstract fun updateJoinRequestByTargetIdAndUserId(
        targetId: String,
        userId: String,
        status: String,
    )

    @Query("DELETE FROM joinRequest WHERE targetId = :targetId AND userId = :userId")
    abstract fun deleteJoinRequestByCommunityIdAndUserId(targetId: String, userId: String)

    @Query("DELETE from joinRequest")
    abstract override fun deleteAll()

    @Query(
        "SELECT *" +
                " from joinRequest" +
                " where joinRequestId = :joinRequestId"
    )
    abstract fun observeJoinRequestImpl(joinRequestId: String): Flowable<JoinRequestEntity>
    fun observeJoinRequest(joinRequestId: String): Flowable<JoinRequestEntity> {
        return observeJoinRequestImpl(joinRequestId)
    }

    @Query(
        "SELECT * FROM joinRequest WHERE targetId = :targetId"
    )
    abstract fun getJoinRequestsByTargetIdImpl(targetId: String): List<JoinRequestEntity>
    fun getJoinRequestsByTargetId(targetId: String): List<JoinRequestEntity> {
        return getJoinRequestsByTargetIdImpl(targetId)
    }
}