package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.dto.video.EkoRoomQueryDto
import com.amity.socialcloud.sdk.dto.video.EkoRoomRecordedUrlsDto
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.socket.request.CreateRoomRequest
import com.ekoapp.ekosdk.internal.api.socket.request.UpdateRoomRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

class RoomRemoteDataStore {

    fun createRoom(request: CreateRoomRequest): Single<EkoRoomQueryDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.createRoom(request)
        }
    }

    fun queryRooms(
        statuses: List<String>?,
        types: List<String>?,
        isDeleted: Boolean?,
        sortBy: String?,
        limit: Int? = null,
        token: String? = null,
    ): Single<EkoRoomQueryDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.queryRooms(
                statuses = statuses,
                types = types,
                isDeleted = isDeleted,
                sortBy = sortBy,
                limit = limit,
                token = token
            )
        }
    }

    fun getRoom(roomId: String): Single<EkoRoomQueryDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.getRoom(roomId)
        }
    }

    fun updateRoom(roomId: String, request: UpdateRoomRequest): Single<EkoRoomQueryDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.updateRoom(roomId, request)
        }
    }

    fun deleteRoom(roomId: String): Single<JsonObject> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.deleteRoom(roomId)
        }
    }

    fun stopRoom(roomId: String): Single<EkoRoomQueryDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.stopRoom(roomId)
        }
    }

    fun getRoomRecordedUrls(roomId: String): Single<EkoRoomRecordedUrlsDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.getRoomRecordedUrls(roomId)
        }
    }
}
