package com.ekoapp.ekosdk.internal.paging

import androidx.paging.*
import co.amity.rxbridge.toRx3
import com.amity.socialcloud.sdk.common.ModelMapper
import com.ekoapp.ekosdk.internal.mediator.SinglePageMediator
import io.reactivex.rxjava3.core.Flowable

@ExperimentalPagingApi
open class SinglePagePagerCreator<Entity : Any, ResponseDto : Any,
    AmityModel: Any>(
    private val mediator: SinglePageMediator<Entity, ResponseDto>,
    private val domainDatasource: Flowable<List<Entity>>,
    private val modelMapper: ModelMapper<Entity, AmityModel>
) {

    open fun create(): Flowable<List<AmityModel>> {
        return mediator.load()
            .andThen(domainDatasource.map { list ->
                list.map(modelMapper::map)
            })
    }
}