package com.ekoapp.ekosdk.internal.api.http

import okhttp3.Interceptor
import okhttp3.Response
import java.util.concurrent.TimeUnit

internal class AmityTimeoutInterceptor : Interceptor {

    override fun intercept(chain: Interceptor.Chain): Response {
        val request = chain.request()
        return request.headers["Custom-Timeout"]?.let {
            val timeout = it.toInt()
            chain.withReadTimeout(timeout, TimeUnit.SECONDS)
                .proceed(request)
        } ?: chain.proceed(request)
    }
}