package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "sub_channel_unread_info", primaryKeys = ["subChannelId"])
open class SubChannelUnreadInfoEntity : EkoObject() {
    
    var subChannelId: String = ObjectId.get().toHexString()
    var channelId: String = ""
    var unreadCount : Int = 0
    var isMentioned: Boolean = false
    var readToSegment: Int = 0
    var lastSegment: Int = 0
    var lastMentionSegment: Int = 0
    var isDeleted: Boolean = false

    override fun getId(): String {
        return subChannelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is SubChannelUnreadInfoEntity
            && Objects.equal(subChannelId, other.subChannelId)
            && Objects.equal(channelId, other.channelId)
            && Objects.equal(unreadCount, other.unreadCount)
            && Objects.equal(isMentioned, other.isMentioned)
            && Objects.equal(readToSegment, other.readToSegment)
            && Objects.equal(lastSegment, other.lastSegment)
            && Objects.equal(lastMentionSegment, other.lastMentionSegment)
            && Objects.equal(createdAt, other.createdAt)
            && Objects.equal(updatedAt, other.updatedAt)
            )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            subChannelId,
            channelId,
            unreadCount,
            isMentioned,
            readToSegment,
            lastSegment,
            lastMentionSegment,
            createdAt,
            updatedAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("subChannelId", subChannelId)
            add("channelId", channelId)
            add("unreadCount", unreadCount)
            add("isMentioned", isMentioned)
            add("readToSegment", readToSegment)
            add("lastSegment", lastSegment)
            add("lastMentionSegment", lastMentionSegment)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
        }
        return super.internalToString(toStringHelper)
    }
    
    fun calculateUnreadCount(): Int {
        return (lastSegment - readToSegment).let {
            if (it < 0) 0 else it
        }
    }
    
    fun calculateIsMentioned(): Boolean {
        return lastMentionSegment > readToSegment
    }

}