package com.amity.socialcloud.sdk.video.data.room

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus
import com.amity.socialcloud.sdk.model.video.room.AmityRoomType

internal class RoomModelMapper : ModelMapper<RoomEntity, AmityRoom>() {

    override fun map(entity: RoomEntity): AmityRoom {
        return entity.run {
            AmityRoom(
                roomId = roomId,
                type = AmityRoomType.enumOf(type),
                targetType = targetType,
                targetId = targetId,
                referenceType = referenceType,
                referenceId = referenceId,
                channelEnabled = channelEnabled,
                channelId = channelId,
                title = title,
                description = description,
                thumbnailFileId = thumbnailFileId,
                status = AmityRoomStatus.enumOf(status),
                participantIds = participants ?: emptyList(),
                livePlaybackUrl = livePlaybackUrl,
                durationSeconds = durationSeconds,
                parentRoomId = parentRoomId,
                childRoomIds = childRoomIds ?: emptyList(),
                creatorId = creatorId,
                isDeleted = isDeleted,
                metadataJson = metadata,
                createdAt = createdAt,
                updatedAt = updatedAt,
                liveAt = liveAt,
                endedAt = endedAt,
                recordedAt = recordedAt
            )
        }
    }
}

