package com.amity.socialcloud.sdk.model.video.room

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityRoom internal constructor(
        private val roomId: String,
        private val type: AmityRoomType,
        private val targetType: String?,
        private val targetId: String?,
        private val referenceType: String?,
        private val referenceId: String?,
        private val channelEnabled: Boolean,
        private val channelId: String?,
        private val title: String?,
        private val description: String?,
        private val thumbnailFileId: String?,
        private val status: AmityRoomStatus,
        private val participantIds: List<String>,
        private val livePlaybackUrl: String?,
        private val durationSeconds: Int?,
        private val parentRoomId: String?,
        private val childRoomIds: List<String>,
        private val creatorId: String?,
        private val isDeleted: Boolean,
        private val metadataJson: JsonObject?,
        private val createdAt: DateTime?,
        private val updatedAt: DateTime?,
        private val liveAt: DateTime?,
        private val endedAt: DateTime?,
        private val recordedAt: DateTime?,
) : Parcelable, ReactorObject {

    internal var creator: AmityUser? = null
    internal var channel: AmityChannel? = null
    internal var moderation: AmityRoomModeration? = null

    fun getRoomId() = roomId
    fun getStatus() = status
    fun getTitle() = title
    fun getDescription() = description
    fun isChannelEnabled() = channelEnabled
    fun getChannelId() = channelId
    fun getParticipantIds() = participantIds
    fun getChildRoomIds() = childRoomIds
    fun getParentRoomId() = parentRoomId
    fun getCreatorId() = creatorId
    fun isDeleted() = isDeleted
    fun getCreatedAt() = createdAt
    fun getUpdatedAt() = updatedAt
    fun getLiveAt() = liveAt
    fun getEndedAt() = endedAt
    fun getRecordedAt() = recordedAt
    fun getLivePlaybackUrl() = livePlaybackUrl
    fun getMetadata() = metadataJson
    fun getModeration(): AmityRoomModeration? = moderation
    override fun updatedAt(): DateTime? {
        return updatedAt
    }
    override fun uniqueId(): String {
        return roomId
    }
}

enum class AmityRoomType(val apiKey: String) { CO_HOSTS("coHosts"), DIRECT_STREAMING("directStreaming"); companion object { fun enumOf(v:String?)= values().find{it.apiKey==v}?:CO_HOSTS } }

enum class AmityRoomStatus(val apiKey: String) { IDLE("idle"), LIVE("live"), WAITING_RECONNECT("waitingReconnect"), ENDED("ended"), RECORDED("recorded"); companion object { fun enumOf(v:String?)= values().find{it.apiKey==v}?:IDLE } }

enum class AmityRoomSortOption(val apiKey: String) { FirstCreated("firstCreated"), LastCreated("lastCreated"); }
