package com.amity.socialcloud.sdk.helper.core.coroutines

import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.reactive.asFlow
import kotlinx.coroutines.rx3.await


suspend fun Completable.await() {
    this.subscribeOn(Schedulers.io()).await()
}

suspend fun <T : Any> Single<T>.await(): T {
    return this.subscribeOn(Schedulers.io()).await()
}

fun <T : Any> Flowable<T>.asFlow(): Flow<T> {
    return this.subscribeOn(Schedulers.io()).asFlow()
}