package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.domain.user.UserObserveUseCase
import com.amity.socialcloud.sdk.model.core.events.AmityFollowEvents
import io.reactivex.rxjava3.core.Single

internal class FollowTopicGeneratorUseCase : TopicGenerationUseCase() {

    fun execute(events: AmityFollowEvents): Single<String> {
        return UserObserveUseCase().execute(AmityCoreClient.getUserId())
            .firstOrError()
            .map {
                val userPath = it.path
                val networkId = userPath.substringBefore("/")
                val userMId = it.mid
                when (events) {
                    AmityFollowEvents.MY_FOLLOWERS -> {
                        "$networkId/membership/$userMId/+/+"
                    }
                    AmityFollowEvents.MY_FOLLOWINGS -> {
                        "$networkId/membership/+/$userMId/+"
                    }
                }
            }
    }

}