package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.model.core.events.AmityCommentEvents
import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import io.reactivex.rxjava3.core.Single

internal class CommentTopicGeneratorUseCase : TopicGenerationUseCase() {

    fun execute(comment: AmityComment, events: AmityCommentEvents) : Single<String> {
        val topic = when (events) {
            AmityCommentEvents.COMMENT -> {
                comment.path
            }
        }
        return Single.just(topic)
    }

}