package com.amity.socialcloud.sdk.core.data.auth

import co.amity.rxbridge.toRx2
import co.amity.rxbridge.toRx3
import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint
import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceRequest
import com.github.davidmoten.rx2.RetryWhen
import io.reactivex.rxjava3.core.Single
import java.util.*
import java.util.concurrent.TimeUnit

internal class TokenRemoteDataStore {

    fun createToken(
        endpoint: AmityEndpoint,
        apiKey: String,
        userId: String,
        displayName: String? = null,
        secureToken: String? = null
    ): Single<RegisterDeviceDto> {
        val deviceId = UUID.randomUUID().toString()
        val request = RegisterDeviceRequest.create(userId, displayName, deviceId, secureToken)
        return TokenApi.token(endpoint)
            .registerDevice(apiKey, request)
            .toRx2()
            .retryWhen(
                RetryWhen
                    .retryIf { AmityError.from(it) != AmityError.USER_IS_GLOBAL_BANNED }
                    .maxRetries(3)
                    .exponentialBackoff(1, 10, TimeUnit.SECONDS, 1.5)
                    .build()
            )
            .toRx3()
    }

}