package com.amity.socialcloud.sdk.api.video.room

import com.amity.socialcloud.sdk.api.video.room.query.AmityRoomQuery
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.video.domain.room.*
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single

class AmityRoomRepository internal constructor() {

    /* begin_public_function
      id: room.query
      api_style: live_collection
    */
    fun getRooms(): AmityRoomQuery.Builder = AmityRoomQuery.Builder()
    /* end_public_function */

    /* begin_public_function
      id: room.get
      api_style: live_object
    */
    fun getRoom(roomId: String): Flowable<AmityRoom> = GetRoomUseCase().execute(roomId)
    /* end_public_function */

    fun fetchRoom(roomId: String): Completable = FetchRoomUseCase().execute(roomId)

    /* begin_public_function
      id: room.create
      api_style: async
    */
    fun createRoom(
        title: String,
        description: String? = null,
        thumbnailFileId: String? = null,
        metadata: JsonObject? = null,
        channelEnabled: Boolean? = null,
        parentRoomId: String? = null,
        participants: List<String> = emptyList(),
    ): Single<AmityRoom> = CreateRoomUseCase().execute(
        title = title,
        description = description,
        thumbnailFileId = thumbnailFileId,
        metadata = metadata,
        channelEnabled = channelEnabled,
        parentRoomId = parentRoomId,
        participants = participants,
    )
    /* end_public_function */

    /* begin_public_function
      id: room.update
      api_style: async
    */
    fun updateRoom(
        roomId: String,
        title: String? = null,
        description: String? = null,
        thumbnailFileId: String? = null,
        metadata: JsonObject? = null,
        channelEnabled: Boolean? = null,
    ): Single<AmityRoom> = UpdateRoomUseCase().execute(
        roomId = roomId,
        title = title,
        description = description,
        thumbnailFileId = thumbnailFileId,
        metadata = metadata,
        channelEnabled = channelEnabled,
    )
    /* end_public_function */

    /* begin_public_function
      id: room.delete
      api_style: async
    */
    fun deleteRoom(roomId: String): Completable = DeleteRoomUseCase().execute(roomId)
    /* end_public_function */

    /* begin_public_function
      id: room.stop
      api_style: async
    */
    fun stopRoom(roomId: String): Single<AmityRoom> = StopRoomUseCase().execute(roomId)
    /* end_public_function */

    fun getRecordedUrls(roomId: String): Single<List<String>> = GetRecordedUrlsUseCase().execute(roomId)
}

