package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.api.dto.ContentCheckDto
import com.ekoapp.ekosdk.internal.api.dto.ContentCheckListDto
import com.ekoapp.ekosdk.internal.api.dto.ContentSettingDto

interface AmityContentCheckListMapper : EkoObjectMapper<ContentCheckListDto, Any> {
	
	companion object {
		val MAPPER: AmityContentCheckListMapper = object: AmityContentCheckListMapper {
			override fun map(dto: ContentCheckListDto) {
				dto.feedSettings.map(::applyFeedTypeToContentSettings)
			}
		}
		
		private fun applyFeedTypeToContentSettings(contentCheckDto: ContentCheckDto): List<ContentSettingDto> {
			return contentCheckDto.contentSettings.map { setting ->
				setting.apply {
					feedType = contentCheckDto.feedType
				}
			}
		}
	}
}