/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.post.paging;

import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ5\u0010\r\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0014\u0010\u0011\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/amity/socialcloud/sdk/social/data/post/paging/UserPostKeyCreator;", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "userId", "", "sortBy", "isDeleted", "", "dataTypes", "", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost$DataType;", "includeMixedStructure", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;Z)V", "Ljava/lang/Boolean;", "getConditionStatement", "includeDeleted", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;Z)Ljava/lang/String;", "getFilterQuery", "getPostTypesAsArrayString", "toMap", "", "", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nUserPostKeyCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserPostKeyCreator.kt\ncom/amity/socialcloud/sdk/social/data/post/paging/UserPostKeyCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1864#2,3:91\n*S KotlinDebug\n*F\n+ 1 UserPostKeyCreator.kt\ncom/amity/socialcloud/sdk/social/data/post/paging/UserPostKeyCreator\n*L\n80#1:91,3\n*E\n"})
public final class UserPostKeyCreator
implements DynamicQueryStreamKeyCreator {
    @NotNull
    private final String userId;
    @NotNull
    private final String sortBy;
    @Nullable
    private final Boolean isDeleted;
    @NotNull
    private final List<AmityPost.DataType> dataTypes;
    private final boolean includeMixedStructure;

    public UserPostKeyCreator(@NotNull String userId, @NotNull String sortBy, @Nullable Boolean isDeleted, @NotNull List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        this.userId = userId;
        this.sortBy = sortBy;
        this.isDeleted = isDeleted;
        this.dataTypes = dataTypes;
        this.includeMixedStructure = includeMixedStructure;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"targetId", (Object)this.userId);
        pairArray[1] = TuplesKt.to((Object)"targetType", (Object)AmityPost.TargetType.USER.getApiKey());
        pairArray[2] = TuplesKt.to((Object)"sortBy", (Object)this.sortBy);
        Boolean bl = this.isDeleted;
        pairArray[3] = TuplesKt.to((Object)"isDeleted", (Object)(bl != null ? bl : false));
        pairArray[4] = TuplesKt.to((Object)"dataTypes", (Object)PostRepositoryHelper.INSTANCE.convertPostTypesToString(this.dataTypes));
        pairArray[5] = TuplesKt.to((Object)"includeMixedStructure", (Object)this.includeMixedStructure);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String getFilterQuery() {
        return this.getConditionStatement(this.userId, this.isDeleted, this.dataTypes, this.includeMixedStructure);
    }

    private final String getConditionStatement(String userId, Boolean includeDeleted, List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Collection collection;
        String userFilterStatement = "post.targetType = '" + AmityPost.TargetType.USER.getApiKey() + "' and post.targetId = '" + userId + "'";
        String isDeletedFilterStatement = "";
        if (Intrinsics.areEqual((Object)includeDeleted, (Object)false)) {
            isDeletedFilterStatement = " and post.isDeleted = 0";
        } else if (Intrinsics.areEqual((Object)includeDeleted, (Object)true)) {
            isDeletedFilterStatement = " and post.isDeleted = 1";
        }
        Object postTypesFilterStatement = "";
        if (!((Collection)dataTypes).isEmpty()) {
            postTypesFilterStatement = " and post.postDataType IN (" + this.getPostTypesAsArrayString(dataTypes) + ")";
        }
        String structureTypeFilterStatement = "";
        if (!includeMixedStructure) {
            structureTypeFilterStatement = " and (post.structureType != 'mixed' OR post.structureType IS NULL)";
        }
        String parentPostFilter = (collection = (Collection)dataTypes) == null || collection.isEmpty() ? " and post.parentPostId is null" : " and post.targetId is not null";
        return userFilterStatement + isDeletedFilterStatement + (String)postTypesFilterStatement + structureTypeFilterStatement + parentPostFilter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPostTypesAsArrayString(@NotNull List<? extends AmityPost.DataType> dataTypes) {
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        StringBuilder typesString = new StringBuilder();
        Iterable $this$forEachIndexed$iv = dataTypes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void dataType;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AmityPost.DataType dataType2 = (AmityPost.DataType)item$iv;
            int index = n;
            boolean bl = false;
            if (index == 0) {
                typesString.append("'" + dataType.getApiKey() + "'");
                continue;
            }
            typesString.append(", '" + dataType.getApiKey() + "'");
        }
        String string = typesString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typesString.toString()");
        return string;
    }

    @Override
    @Nullable
    public String optionalFilterQuery() {
        return DynamicQueryStreamKeyCreator.DefaultImpls.optionalFilterQuery(this);
    }
}

