package com.amity.socialcloud.sdk.video.data.moderation

import com.amity.socialcloud.sdk.entity.video.stream.StreamModerationEntity
import com.amity.socialcloud.sdk.video.data.stream.StreamLocalDataStore
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable


internal class StreamModerationLocalDataStore {

    fun saveStreamModerations(streamModerations: List<StreamModerationEntity>): Completable {
        return Completable.fromAction {
            UserDatabase.get().streamModerationDao().save(streamModerations)
        }.andThen(Completable.fromAction {
            streamModerations.map {
                it.streamId
            }.distinct()
                .forEach {
                    StreamLocalDataStore().notifyChanges(it)
                }
        })
    }

    fun getStreamModeration(moderationId: String): StreamModerationEntity? {
        return UserDatabase.get().streamModerationDao().getByIdNow(moderationId)
    }

}