package com.amity.socialcloud.sdk.social.data.post.paging

import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator


internal class GlobalPinKeyCreator(
    private val includeMixedStructure: Boolean
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf("includeMixedStructure" to (includeMixedStructure))
    }

    override fun getFilterQuery(): String {
        var filterQuery = " pin.placement = 'global'"
        
        //structureType filter - exclude mixed structure posts when includeMixedStructure is false
        if (!includeMixedStructure) {
            filterQuery += " and (post.structureType != 'mixed' OR post.structureType IS NULL)"
        }
        
        return filterQuery
    }
}