package com.amity.socialcloud.sdk.model.core.file.upload

import android.net.Uri
import co.amity.rxupload.FileProperties


class AmityUploadInfo internal constructor(private val fileProperties: FileProperties) {

    fun getBytesWritten(): Long {
        return fileProperties.bytesWritten
    }

    fun getProgressPercentage(): Int {
        return fileProperties.progress
    }

    fun getContentLength(): Long {
        return fileProperties.contentLength
    }

    @Deprecated("Please use getFileUri() instead")
    fun getFilePath(): String? {
        return fileProperties.uri.path
    }

    fun getFileUri(): Uri {
        return fileProperties.uri
    }

}