package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.ekoapp.ekosdk.internal.api.dto.ChannelMutedDto

internal class ChannelSetMuted : ChannelMutedEventListener() {

    override fun getEventName(): String {
        return "channel.setMuted"
    }

    override fun processEvent(dto: ChannelMutedDto) {
        dto.channelId?.let { channelId ->
            if (dto.muteTimeout?.isAfterNow == true) {
                ChannelRepository().setIsMutedChannel(channelId, true)
            } else {
                ChannelRepository().setIsMutedChannel(channelId, false)
            }
        }
    }

}