package com.amity.socialcloud.sdk.core.data.notificationtray

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTrayQueryDto
import io.reactivex.rxjava3.core.Completable

class NotificationTrayQueryPersister : QueryPersister<NotificationTrayQueryDto>() {
    override fun persist(dto: NotificationTrayQueryDto): Completable {
        return NotificationTrayLocalDataStore().saveNotificationTrayItems(
            NotificationTrayItemEntityMapper().map(dto.notificationTrayItems ?: emptyList())
        )
            .andThen(
                UserLocalDataStore().saveUsers(
                    UserEntityMapper().map(
                        dto.users ?: emptyList()
                    )
                )
            )
            .andThen(
                FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            )
    }
}