/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.hash;

import com.ekoapp.ekosdk.internal.api.hash.EkoFnv1a;

public class EkoBloomFilter {
    private static final int SEED = 1576284489;
    private final byte[] buckets;
    private final int m;
    private final int k;

    private EkoBloomFilter(byte[] buckets, int m, int k) {
        this.buckets = buckets;
        this.m = m;
        this.k = k;
    }

    public boolean mightContains(String element) {
        int[] locations = this.locationFor(element.getBytes());
        for (int i = 0; i < this.k; ++i) {
            int location = locations[i];
            int index = (int)Math.floor(location / 8);
            if ((this.buckets[index] & 1 << location % 8) != 0) continue;
            return false;
        }
        return true;
    }

    private int[] locationFor(byte[] buf) {
        int hash1 = new EkoFnv1a().hash(buf, 0);
        int hash2 = new EkoFnv1a().hash(buf, 1576284489);
        int[] locations = new int[this.k];
        int location = hash1 % this.m;
        for (int i = 0; i < this.k; ++i) {
            locations[i] = location < 0 ? location + this.m : location;
            location = (location + hash2) % this.m;
        }
        return locations;
    }

    public static class Builder {
        private final byte[] buckets;
        private final int m;
        private final int k;

        public Builder(byte[] buckets, int m, int k) {
            this.buckets = buckets;
            this.m = m;
            this.k = k;
        }

        public EkoBloomFilter build() {
            return new EkoBloomFilter(this.buckets, this.m, this.k);
        }
    }
}

