/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.story.markseen;

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository;
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsService;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventContentType;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget;
import com.amity.socialcloud.sdk.social.data.story.StoryRepository;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository;
import com.ekoapp.ekosdk.internal.entity.AnalyticsEventEntity;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/story/markseen/MarkStoryAsViewedUseCase;", "", "()V", "execute", "", "story", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory;", "amity-sdk_release"})
public final class MarkStoryAsViewedUseCase {
    public final void execute(@NotNull AmityStory story) {
        Intrinsics.checkNotNullParameter((Object)story, (String)"story");
        if (story.getState() != AmityStory.State.SYNCED) {
            return;
        }
        AnalyticsEventEntity event = AnalyticsRepository.createAnalyticEvent$default(new AnalyticsRepository(), story.getStoryId(), AnalyticsEventContentType.STORY, "view", AnalyticsEventSyncPriority.HIGH, story.getStoryId() + ".view", null, 32, null);
        new AnalyticsService().captureEvent(event);
        String storyId = story.getStoryId();
        AmityStoryTarget storyTarget = new StoryTargetRepository().getStoryTarget(story.getTargetType(), story.getTargetId());
        if (storyTarget != null) {
            boolean bl;
            DateTime dateTime = story.getExpiresAt();
            if (dateTime != null) {
                DateTime dateTime2 = storyTarget.getHighestSeen$amity_sdk_release();
                if (dateTime2 == null) {
                    dateTime2 = DateTime.now();
                }
                bl = dateTime.isAfter((ReadableInstant)dateTime2);
            } else {
                bl = false;
            }
            if (bl) {
                new StoryTargetRepository().updateStoryTargetLocalLastStorySeenExpiresAt(story.getTargetType(), story.getTargetId(), story.getExpiresAt()).andThen((CompletableSource)new StoryRepository().triggerStoryReload(storyId)).onErrorComplete().subscribeOn(Schedulers.io()).subscribe();
            }
        }
    }
}

