/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.post;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.social.post.query.AmityCommunityFeedSortOption;
import com.amity.socialcloud.sdk.api.social.post.query.AmityUserFeedSortOption;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006JO\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006J(\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0011J(\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0011J[\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006J \u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00130\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013JL\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010(\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010)\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0011J]\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020,2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010)\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\u0002\u0010.JG\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020,2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u0002022\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u00103\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u00104\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u00105\u001a\u0002022\u0006\u0010\u0005\u001a\u00020\u00062\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\u000e\u00107\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u00109\u001a\u0002022\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0\u0013J6\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010=\u001a\u0002022\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010>\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006?"}, d2={"Lcom/amity/socialcloud/sdk/social/data/post/PostLocalDataStore;", "", "()V", "decrementCommentCount", "", "postId", "", "getCommunityPostsPagingSource", "Landroidx/paging/PagingSource;", "", "Lcom/ekoapp/ekosdk/internal/PostEntity;", "communityId", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityFeedSortOption;", "feedType", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "isDeleted", "", "postTypes", "", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost$DataType;", "includeMixedStructure", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityFeedSortOption;Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;Ljava/lang/Boolean;Ljava/util/List;Z)Landroidx/paging/PagingSource;", "getFeedType", "getGlobalPostsPagingSource", "dataTypes", "getGlobalPostsV5PagingSource", "getLatestPosts", "Lio/reactivex/rxjava3/core/Flowable;", "targetId", "targetType", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;ILjava/lang/Boolean;Ljava/util/List;ZLcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;)Lio/reactivex/rxjava3/core/Flowable;", "getPost", "getPostByIds", "postIds", "getPosts", "getSemanticSearchPostsPagingSource", "query", "matchingOnlyParentPosts", "getUserFeedPagingSource", "userId", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityUserFeedSortOption;", "feedSources", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/social/post/query/AmityUserFeedSortOption;Ljava/lang/Boolean;Ljava/util/List;ZLjava/util/List;Z)Landroidx/paging/PagingSource;", "getUserPostsPagingSource", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/social/post/query/AmityUserFeedSortOption;Ljava/lang/Boolean;Ljava/util/List;Z)Landroidx/paging/PagingSource;", "hardDelete", "Lio/reactivex/rxjava3/core/Completable;", "hasInLocal", "incrementCommentCount", "invalidateChildPosts", "childPostIds", "notifyPost", "observe", "savePosts", "posts", "searchPostsPagingSource", "hashtags", "softDelete", "updateFeedType", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nPostLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/post/PostLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n1179#2,2:256\n1253#2,4:258\n1045#2:262\n*S KotlinDebug\n*F\n+ 1 PostLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/post/PostLocalDataStore\n*L\n103#1:256,2\n103#1:258,4\n104#1:262\n*E\n"})
public final class PostLocalDataStore {
    public final boolean hasInLocal(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return UserDatabase.get().postDao().getByIdNow(postId) != null;
    }

    @NotNull
    public final Completable savePosts(@NotNull List<? extends PostEntity> posts) {
        Intrinsics.checkNotNullParameter(posts, (String)"posts");
        Completable completable = Completable.fromAction(() -> PostLocalDataStore.savePosts$lambda$0(posts));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026o().updatePin()\n        }");
        return completable;
    }

    public final void updateFeedType(@NotNull String postId, @NotNull AmityFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        UserDatabase.get().postDao().updateFeedType(postId, feedType.getApiKey());
    }

    @NotNull
    public final AmityFeedType getFeedType(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Ref.ObjectRef feedType = new Ref.ObjectRef();
        feedType.element = AmityFeedType.NONE;
        Completable.fromCallable(() -> PostLocalDataStore.getFeedType$lambda$1(postId, feedType)).subscribeOn(Schedulers.io()).blockingAwait();
        return (AmityFeedType)((Object)feedType.element);
    }

    @NotNull
    public final Flowable<PostEntity> observe(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Flowable flowable = UserDatabase.get().postDao().observePost(postId).map((Function)observe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"get().postDao().observeP\u2026          }\n            }");
        return flowable;
    }

    @NotNull
    public final Completable hardDelete(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Completable completable = UserDatabase.get().postDao().deleteById(postId).andThen((CompletableSource)Completable.fromAction(PostLocalDataStore::hardDelete$lambda$2));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"get().postDao().deleteBy\u2026          }\n            )");
        return completable;
    }

    @NotNull
    public final Completable softDelete(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Completable completable = UserDatabase.get().postDao().softDeleteById(postId).andThen((CompletableSource)Completable.fromAction(PostLocalDataStore::softDelete$lambda$3));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"get().postDao().softDele\u2026          }\n            )");
        return completable;
    }

    @NotNull
    public final Completable invalidateChildPosts(@NotNull String postId, @NotNull List<String> childPostIds) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter(childPostIds, (String)"childPostIds");
        return UserDatabase.get().postDao().invalidateChildPosts(postId, childPostIds);
    }

    @Nullable
    public final PostEntity getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Ref.ObjectRef post = new Ref.ObjectRef();
        Completable.fromCallable(() -> PostLocalDataStore.getPost$lambda$4(postId, post)).subscribeOn(Schedulers.io()).blockingAwait();
        return (PostEntity)post.element;
    }

    @NotNull
    public final List<PostEntity> getPosts(@NotNull List<String> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Ref.ObjectRef posts = new Ref.ObjectRef();
        posts.element = CollectionsKt.emptyList();
        Completable.fromCallable(() -> PostLocalDataStore.getPosts$lambda$8(postIds, posts)).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)posts.element;
    }

    @NotNull
    public final PagingSource<Integer, PostEntity> getCommunityPostsPagingSource(@NotNull String communityId, @NotNull AmityCommunityFeedSortOption sortOption, @NotNull AmityFeedType feedType, @Nullable Boolean isDeleted, @NotNull List<? extends AmityPost.DataType> postTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        return UserDatabase.get().communityPostPagingDao().getCommunityPostPagingSource(communityId, feedType, isDeleted, sortOption.getApiKey(), postTypes, includeMixedStructure);
    }

    @NotNull
    public final PagingSource<Integer, PostEntity> getUserPostsPagingSource(@NotNull String userId, @NotNull AmityUserFeedSortOption sortOption, @Nullable Boolean isDeleted, @NotNull List<? extends AmityPost.DataType> postTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        return UserDatabase.get().userPostPagingDao().getUserPostPagingSource(userId, isDeleted, sortOption.getApiKey(), postTypes, includeMixedStructure);
    }

    @NotNull
    public final PagingSource<Integer, PostEntity> getUserFeedPagingSource(@NotNull String userId, @NotNull AmityUserFeedSortOption sortOption, @Nullable Boolean isDeleted, @NotNull List<String> feedSources, boolean matchingOnlyParentPosts, @NotNull List<? extends AmityPost.DataType> postTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter(feedSources, (String)"feedSources");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        return UserDatabase.get().userFeedPagingDao().getUserFeedPagingSource(userId, sortOption, isDeleted, feedSources, matchingOnlyParentPosts, postTypes, includeMixedStructure);
    }

    @NotNull
    public final PagingSource<Integer, PostEntity> getSemanticSearchPostsPagingSource(@NotNull String query, @Nullable String targetId, @Nullable String targetType, boolean matchingOnlyParentPosts, @NotNull List<? extends AmityPost.DataType> postTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        return UserDatabase.get().semanticSearchPostPagingDao().getSearchPostPagingSource(query, targetType, targetId, matchingOnlyParentPosts, postTypes, includeMixedStructure);
    }

    @NotNull
    public final PagingSource<Integer, PostEntity> searchPostsPagingSource(@NotNull List<String> hashtags, @NotNull List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter(hashtags, (String)"hashtags");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        return UserDatabase.get().searchPostsPagingDao().searchPostsByHashtag(hashtags, dataTypes, includeMixedStructure);
    }

    @NotNull
    public final PagingSource<Integer, PostEntity> getGlobalPostsPagingSource(@NotNull List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        return UserDatabase.get().globalFeedPagingDao().queryGlobalFeedPost(dataTypes, includeMixedStructure);
    }

    @NotNull
    public final PagingSource<Integer, PostEntity> getGlobalPostsV5PagingSource(@NotNull List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        return UserDatabase.get().globalFeedV5PagingDao().queryGlobalFeedPost(dataTypes, includeMixedStructure);
    }

    public final void incrementCommentCount(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        UserDatabase.get().postDao().incrementCommentCount(postId);
    }

    public final void decrementCommentCount(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        UserDatabase.get().postDao().decrementCommentCount(postId);
    }

    public final void notifyPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        UserDatabase.get().postDao().updatePost(postId);
        UserDatabase.get().pinDao().updatePin();
    }

    @NotNull
    public final Flowable<PostEntity> getLatestPosts(@NotNull String targetId, @NotNull String targetType, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce, @Nullable Boolean isDeleted, @NotNull List<String> dataTypes, boolean includeMixedStructure, @Nullable AmityFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        return UserDatabase.get().postDao().getLatestPost(targetId, targetType, isDeleted, dataTypes, ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode(), nonce, feedType);
    }

    @NotNull
    public final Flowable<List<PostEntity>> getPostByIds(@NotNull List<String> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        return UserDatabase.get().postDao().getByPostIds(postIds);
    }

    private static final void savePosts$lambda$0(List $posts) {
        Intrinsics.checkNotNullParameter((Object)$posts, (String)"$posts");
        UserDatabase.get().postDao().save($posts);
        UserDatabase.get().pinDao().updatePin();
    }

    private static final Unit getFeedType$lambda$1(String $postId, Ref.ObjectRef $feedType) {
        Intrinsics.checkNotNullParameter((Object)$postId, (String)"$postId");
        Intrinsics.checkNotNullParameter((Object)$feedType, (String)"$feedType");
        PostEntity post = UserDatabase.get().postDao().getByIdNow($postId);
        if (post != null) {
            $feedType.element = AmityFeedType.Companion.enumOf(post.getFeedType());
        }
        return Unit.INSTANCE;
    }

    private static final void hardDelete$lambda$2() {
        UserDatabase.get().pinDao().updatePin();
    }

    private static final void softDelete$lambda$3() {
        UserDatabase.get().pinDao().updatePin();
    }

    private static final Unit getPost$lambda$4(String $postId, Ref.ObjectRef $post) {
        Intrinsics.checkNotNullParameter((Object)$postId, (String)"$postId");
        Intrinsics.checkNotNullParameter((Object)$post, (String)"$post");
        PostEntity entity = UserDatabase.get().postDao().getByIdNow($postId);
        if (entity != null) {
            $post.element = entity;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getPosts$lambda$8(List $postIds, Ref.ObjectRef $posts) {
        Intrinsics.checkNotNullParameter((Object)$postIds, (String)"$postIds");
        Intrinsics.checkNotNullParameter((Object)$posts, (String)"$posts");
        PostDao postDao = UserDatabase.get().postDao();
        List<PostEntity> entities = postDao.getByIdsNow($postIds);
        if (!((Collection)entities).isEmpty()) {
            void children;
            void $this$associateTo$iv$iv;
            List<PostEntity> list2 = entities;
            Ref.ObjectRef objectRef = $posts;
            boolean bl = false;
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)$postIds);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue it = (IndexedValue)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map orderById = destination$iv$iv;
            Iterable $this$sortedBy$iv = (Iterable)children;
            boolean $i$f$sortedBy = false;
            List sortedPost = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderById){
                final /* synthetic */ Map $orderById$inlined;
                {
                    this.$orderById$inlined = map;
                }

                public final int compare(T a, T b) {
                    PostEntity it = (PostEntity)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)this.$orderById$inlined.get(it.getPostId());
                    it = (PostEntity)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderById$inlined.get(it.getPostId())));
                }
            });
            objectRef.element = sortedPost;
        }
        return Unit.INSTANCE;
    }
}

