package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.google.gson.reflect.TypeToken

class StringListConverter {
	@TypeConverter
	fun stringToStringList(json: String?): List<String> {
		if (json.isNullOrEmpty()) {
			return emptyList()
		}
		return try {
			EkoGson.get().fromJson(json, object : TypeToken<List<String>>() {}.type) ?: emptyList()
		} catch (e: Exception) {
			emptyList()
		}
	}
	
	@TypeConverter
	fun stringListToString(list: List<String?>?): String {
		return if (list.isNullOrEmpty()) {
			"[]"
		} else {
			EkoGson.get().toJson(list)
		}
	}
}