package com.amity.socialcloud.sdk.core.data.notification.community

import com.amity.socialcloud.sdk.model.social.notification.AmityCommunityNotificationEvent
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoPushNotificationEventDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityNotificationEventRequestMapper
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CommunityNotificationRemoteDataStore {

    fun getSetting(communityId: String): Single<EkoPushNotificationEventDto> {
        return AmityHttpClient.get(CommunityNotificationApi::class).flatMap {
            it.getSetting(communityId = communityId)
        }
    }

    fun saveSetting( communityId: String,
                     isEnabled: Boolean,
                     eventModifiers: List<AmityCommunityNotificationEvent.MODIFIER>?): Single<JsonObject> {
        val request = NotificationSaveSettingsRequest.Community(
            communityId,
            isEnabled,
            EkoCommunityNotificationEventRequestMapper().map(eventModifiers)
        )
        return AmityHttpClient.get(CommunityNotificationApi::class).flatMap {
            it.saveSetting(request)
        }
    }
}