/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.ChannelMarkerEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.ChannelMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class ChannelMarkerDao_Impl
extends ChannelMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<ChannelMarkerEntity> __insertAdapterOfChannelMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<ChannelMarkerEntity> __deleteAdapterOfChannelMarkerEntity;
    private final EntityDeleteOrUpdateAdapter<ChannelMarkerEntity> __updateAdapterOfChannelMarkerEntity;

    public ChannelMarkerDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfChannelMarkerEntity = new EntityInsertAdapter<ChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `channel_marker` (`channelId`,`userId`,`unreadCount`,`isDeleted`,`hasMentioned`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelMarkerEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
                statement.bindLong(3, (long)entity.getUnreadCount());
                int _tmp = entity.isDeleted() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                int _tmp_1 = entity.getHasMentioned() ? 1 : 0;
                statement.bindLong(5, (long)_tmp_1);
                String _tmp_2 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                String _tmp_3 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_3);
                }
                String _tmp_4 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfChannelMarkerEntity = new EntityDeleteOrUpdateAdapter<ChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `channel_marker` WHERE `channelId` = ? AND `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelMarkerEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfChannelMarkerEntity = new EntityDeleteOrUpdateAdapter<ChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `channel_marker` SET `channelId` = ?,`userId` = ?,`unreadCount` = ?,`isDeleted` = ?,`hasMentioned` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ? AND `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelMarkerEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
                statement.bindLong(3, (long)entity.getUnreadCount());
                int _tmp = entity.isDeleted() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                int _tmp_1 = entity.getHasMentioned() ? 1 : 0;
                statement.bindLong(5, (long)_tmp_1);
                String _tmp_2 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                String _tmp_3 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_3);
                }
                String _tmp_4 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_4);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(ChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelMarkerEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends ChannelMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelMarkerEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(ChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends ChannelMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelMarkerEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(ChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfChannelMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(ChannelMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelMarkerDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends ChannelMarkerEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelMarkerDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(ChannelMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelMarkerDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public ChannelMarkerEntity getByIdNow(String channelId) {
        String _sql = "SELECT * from channel_marker where channelId = ? LIMIT 1";
        return (ChannelMarkerEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_marker where channelId = ? LIMIT 1");){
                ChannelMarkerEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfHasMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasMentioned");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelMarkerEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfHasMentioned);
                    boolean _tmpHasMentioned = _tmp_1 != 0;
                    _result.setHasMentioned(_tmpHasMentioned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelMarkerEntity channelMarkerEntity = _result;
                return channelMarkerEntity;
            }
        });
    }

    @Override
    public Flowable<ChannelMarkerEntity> getById(String channelId) {
        String _sql = "SELECT * from channel_marker where channelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_marker"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_marker where channelId = ? LIMIT 1");){
                ChannelMarkerEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfHasMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasMentioned");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelMarkerEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfHasMentioned);
                    boolean _tmpHasMentioned = _tmp_1 != 0;
                    _result.setHasMentioned(_tmpHasMentioned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelMarkerEntity channelMarkerEntity = _result;
                return channelMarkerEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from channel_marker";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_marker");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String channelId) {
        String _sql = "DELETE from channel_marker where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_marker where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

