/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.subchannel;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository;
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelModelMapper;
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelQueryPersister;
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository;
import com.amity.socialcloud.sdk.chat.data.subchannel.paging.SubChannelMediator;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.data.tombstone.TombstoneRepository;
import com.amity.socialcloud.sdk.model.chat.subchannel.AmitySubChannel;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.ekoapp.ekosdk.internal.SubChannelEntity;
import com.ekoapp.ekosdk.internal.TombstoneModelType;
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00190\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0014\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010+\u001a\u00020 H\u0000\u00a2\u0006\u0002\b,J\u001d\u0010-\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010+\u001a\u00020 H\u0000\u00a2\u0006\u0002\b.J\u001b\u0010/\u001a\u00020*2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t01H\u0000\u00a2\u0006\u0002\b2J\u0010\u00103\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0002J\u001d\u00104\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\t2\u0006\u00105\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b8J\b\u00109\u001a\u00020 H\u0002\u00a8\u0006:"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/subchannel/SubChannelRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/SubChannelEntity;", "Lcom/amity/socialcloud/sdk/model/chat/subchannel/AmitySubChannel;", "<init>", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "createSubChannel", "Lio/reactivex/rxjava3/core/Single;", "channelId", "name", "updateSubChannel", "subChannelId", "deleteSubChannel", "hardDelete", "", "getSubChannelPagingData", "Landroidx/paging/PagingData;", "excludeMainSubChannel", "isDeleted", "getLatestSubChannel", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "", "getSubChannel", "getSubChannel$amity_sdk_release", "persistSubChannels", "dto", "Lcom/ekoapp/ekosdk/internal/api/dto/SubChannelListDto;", "persistSubChannels$amity_sdk_release", "persistAndReturnSubChannels", "persistAndReturnSubChannels$amity_sdk_release", "updateMarkerHash", "", "hash", "updateMarkerHash$amity_sdk_release", "updateUserMarkerHash", "updateUserMarkerHash$amity_sdk_release", "notifySubChannelChanges", "subChannelIds", "", "notifySubChannelChanges$amity_sdk_release", "fetchSubChannelMarker", "updateMessagePreview", "messagePreviewId", "updateMessagePreview$amity_sdk_release", "notifyChanges", "notifyChanges$amity_sdk_release", "getDefaultPageSize", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nSubChannelRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubChannelRepository.kt\ncom/amity/socialcloud/sdk/chat/data/subchannel/SubChannelRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n774#2:193\n865#2,2:194\n1617#2,9:196\n1869#2:205\n1870#2:207\n1626#2:208\n1#3:206\n*S KotlinDebug\n*F\n+ 1 SubChannelRepository.kt\ncom/amity/socialcloud/sdk/chat/data/subchannel/SubChannelRepository\n*L\n165#1:193\n165#1:194,2\n168#1:196,9\n168#1:205\n168#1:207\n168#1:208\n168#1:206\n*E\n"})
public final class SubChannelRepository
extends AmityObjectRepository<SubChannelEntity, AmitySubChannel> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new SubChannelRemoteDataStore().fetchSubChannel(objectId).flatMapCompletable(new Function(this){
            final /* synthetic */ SubChannelRepository this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(SubChannelListDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return (CompletableSource)SubChannelRepository.access$fetchSubChannelMarker(this.this$0, dto).andThen((CompletableSource)this.this$0.persistSubChannels$amity_sdk_release(dto));
            }
        }).onErrorResumeNext(new Function(objectId){
            final /* synthetic */ String $objectId;
            {
                this.$objectId = $objectId;
            }

            public final CompletableSource apply(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND ? (CompletableSource)new SubChannelLocalDataStore().hardDelete(this.$objectId).andThen((CompletableSource)Completable.error((Throwable)it)) : (CompletableSource)Completable.error((Throwable)it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorResumeNext(...)");
        return completable;
    }

    @Override
    @Nullable
    public SubChannelEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new SubChannelLocalDataStore().getSubChannel(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<SubChannelEntity, AmitySubChannel> mapper() {
        return new SubChannelModelMapper();
    }

    @Override
    @NotNull
    public Flowable<SubChannelEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new SubChannelLocalDataStore().observe(objectId);
    }

    @NotNull
    public final Single<AmitySubChannel> createSubChannel(@NotNull String channelId, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Single single = new SubChannelRemoteDataStore().createSubChannel(channelId, name).flatMap(new Function(this){
            final /* synthetic */ SubChannelRepository this$0;
            {
                this.this$0 = $receiver;
            }

            public final SingleSource<? extends AmitySubChannel> apply(SubChannelListDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return (SingleSource)SubChannelRepository.access$fetchSubChannelMarker(this.this$0, dto).andThen((SingleSource)this.this$0.persistAndReturnSubChannels$amity_sdk_release(dto));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Completable updateSubChannel(@NotNull String subChannelId, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Completable completable = new SubChannelRemoteDataStore().updateSubChannel(subChannelId, name).flatMapCompletable(new Function(this){
            final /* synthetic */ SubChannelRepository this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(SubChannelListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)this.this$0.persistSubChannels$amity_sdk_release(it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable deleteSubChannel(@NotNull String subChannelId, boolean hardDelete) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = new SubChannelRemoteDataStore().deleteSubChannel(subChannelId, hardDelete).flatMap(new Function(this){
            final /* synthetic */ SubChannelRepository this$0;
            {
                this.this$0 = $receiver;
            }

            public final SingleSource<? extends SubChannelDto> apply(SubChannelListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (SingleSource)this.this$0.persistSubChannels$amity_sdk_release(it).andThen((SingleSource)Single.just((Object)CollectionsKt.first(it.getSubChannels())));
            }
        }).flatMapCompletable(new Function(hardDelete, subChannelId){
            final /* synthetic */ boolean $hardDelete;
            final /* synthetic */ String $subChannelId;
            {
                this.$hardDelete = $hardDelete;
                this.$subChannelId = $subChannelId;
            }

            public final CompletableSource apply(SubChannelDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.isDeleted(), (Object)false) ? (CompletableSource)Completable.complete() : (this.$hardDelete ? (CompletableSource)new SubChannelLocalDataStore().hardDelete(this.$subChannelId).andThen((CompletableSource)Completable.defer(() -> deleteSubChannel.2.apply$lambda$0(this.$subChannelId))) : (CompletableSource)new SubChannelLocalDataStore().softDelete(this.$subChannelId));
            }

            private static final CompletableSource apply$lambda$0(String $subChannelId) {
                return (CompletableSource)new TombstoneRepository().saveTombstone($subChannelId, TombstoneModelType.SUB_CHANNEL, AmityError.ITEM_NOT_FOUND);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Flowable<PagingData<AmitySubChannel>> getSubChannelPagingData(@NotNull String channelId, boolean excludeMainSubChannel, boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new SubChannelMediator(channelId, excludeMainSubChannel, isDeleted), () -> SubChannelRepository.getSubChannelPagingData$lambda$0(channelId, isDeleted), (ModelMapper)new SubChannelModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<AmitySubChannel> getLatestSubChannel(boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new SubChannelLocalDataStore().getLatestSubChannel(isDeleted, dynamicQueryStreamKeyCreator, nonce).map((Function)getLatestSubChannel.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Single<AmitySubChannel> getSubChannel$amity_sdk_release(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Single single = new SubChannelLocalDataStore().observe(subChannelId).firstOrError().map((Function)getSubChannel.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"map(...)");
        return single;
    }

    @NotNull
    public final Completable persistSubChannels$amity_sdk_release(@NotNull SubChannelListDto dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        return new SubChannelQueryPersister().persist(dto);
    }

    @NotNull
    public final Single<AmitySubChannel> persistAndReturnSubChannels$amity_sdk_release(@NotNull SubChannelListDto dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Completable completable = this.persistSubChannels$amity_sdk_release(dto);
        String string = ((SubChannelDto)CollectionsKt.first(dto.getSubChannels())).getSubChannelId();
        Intrinsics.checkNotNull((Object)string);
        Single single = completable.andThen((SingleSource)this.getSubChannel$amity_sdk_release(string));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"andThen(...)");
        return single;
    }

    public final void updateMarkerHash$amity_sdk_release(@NotNull String subChannelId, int hash) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        new SubChannelLocalDataStore().updateMarkerHash(subChannelId, hash);
    }

    public final void updateUserMarkerHash$amity_sdk_release(@NotNull String subChannelId, int hash) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        new SubChannelLocalDataStore().updateUserMarkerHash(subChannelId, hash);
    }

    public final void notifySubChannelChanges$amity_sdk_release(@NotNull List<String> subChannelIds) {
        Intrinsics.checkNotNullParameter(subChannelIds, (String)"subChannelIds");
        new SubChannelLocalDataStore().notifySubChannelsChanges(subChannelIds);
    }

    /*
     * WARNING - void declaration
     */
    private final Completable fetchSubChannelMarker(SubChannelListDto dto) {
        Completable completable;
        if (CoreClient.INSTANCE.isUnreadCountEnable()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = dto.getSubChannels();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SubChannelDto it = (SubChannelDto)element$iv$iv;
                boolean bl = false;
                if (!MarkerSyncEngine.Companion.isMarkerSyncSupport(it.getChannelType())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SubChannelDto it = (SubChannelDto)element$iv$iv;
                boolean bl2 = false;
                if (it.getSubChannelId() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List subChannelIds = (List)destination$iv$iv;
            boolean bl = false;
            Completable completable2 = (subChannelIds.isEmpty() ? Completable.complete() : new SubChannelMarkerRepository().fetchSubChannelMarker(subChannelIds)).onErrorComplete();
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            Completable completable3 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    @NotNull
    public final Completable updateMessagePreview$amity_sdk_release(@NotNull String subChannelId, @NotNull String messagePreviewId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)messagePreviewId, (String)"messagePreviewId");
        return new SubChannelLocalDataStore().updateMessagePreview(subChannelId, messagePreviewId);
    }

    public final void notifyChanges$amity_sdk_release(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        new SubChannelLocalDataStore().notifyChanges(subChannelId);
    }

    private final int getDefaultPageSize() {
        return 20;
    }

    private static final PagingSource getSubChannelPagingData$lambda$0(String $channelId, boolean $isDeleted) {
        return new SubChannelLocalDataStore().getSubChannelPagingSource($channelId, $isDeleted);
    }

    public static final /* synthetic */ Completable access$fetchSubChannelMarker(SubChannelRepository $this, SubChannelListDto dto) {
        return $this.fetchSubChannelMarker(dto);
    }
}

