/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.marker.message;

import androidx.paging.ExperimentalPagingApi;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRepository;
import com.amity.socialcloud.sdk.chat.data.marker.reader.MarkReadRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageDeliveredUsersRequest;
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageReadUsersRequest;
import com.amity.socialcloud.sdk.chat.data.marker.readuser.paging.MessageDeliveredUsersMediator;
import com.amity.socialcloud.sdk.chat.data.marker.readuser.paging.MessageReadUsersMediator;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.data.user.UserModelMapper;
import com.amity.socialcloud.sdk.model.chat.message.MessageDeliveredMembershipFilter;
import com.amity.socialcloud.sdk.model.chat.message.MessageReadMembershipFilter;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.ekoapp.ekosdk.internal.MessageMarkerEntity;
import com.ekoapp.ekosdk.internal.api.dto.MessageDeliveredUsersQueryDto;
import com.ekoapp.ekosdk.internal.api.dto.MessageReadUsersQueryDto;
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0014\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007J\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\nJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J*\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a2\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007H\u0007J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010\u0017\u001a\u00020!J*\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a2\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020#0\u0007H\u0007\u00a8\u0006$"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/marker/message/MessageMarkerRepository;", "", "<init>", "()V", "fetchMessageMarker", "Lio/reactivex/rxjava3/core/Completable;", "messageIds", "", "", "getReadCount", "", "messageId", "getDeliveredCount", "saveLocalMessageMarkers", "markers", "Lcom/ekoapp/ekosdk/internal/MessageMarkerEntity;", "markMessageDelivered", "subChannel", "markMessageRead", "readToSegment", "fetchMessageReadUsers", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/api/dto/MessageReadUsersQueryDto;", "request", "Lcom/amity/socialcloud/sdk/chat/data/marker/readuser/MessageReadUsersRequest;", "getMessageReadUsers", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "memberships", "Lcom/amity/socialcloud/sdk/model/chat/message/MessageReadMembershipFilter;", "fetchMessageDeliveredUsers", "Lcom/ekoapp/ekosdk/internal/api/dto/MessageDeliveredUsersQueryDto;", "Lcom/amity/socialcloud/sdk/chat/data/marker/readuser/MessageDeliveredUsersRequest;", "getMessageDeliveredUsers", "Lcom/amity/socialcloud/sdk/model/chat/message/MessageDeliveredMembershipFilter;", "amity-sdk_release"})
public final class MessageMarkerRepository {
    @NotNull
    public final Completable fetchMessageMarker(@NotNull List<String> messageIds) {
        Completable completable;
        Intrinsics.checkNotNullParameter(messageIds, (String)"messageIds");
        if (CoreClient.INSTANCE.isUnreadCountEnable()) {
            Completable completable2 = new MessageMarkerRemoteDataStore().queryMessageMarkers(messageIds).flatMapCompletable((Function)fetchMessageMarker.1.INSTANCE);
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            Completable completable3 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    public final int getReadCount(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        MessageMarkerEntity messageMarkerEntity = new MessageMarkerLocalDataStore().getMessageMarker(messageId);
        return messageMarkerEntity != null ? messageMarkerEntity.getReadCount() : 0;
    }

    public final int getDeliveredCount(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        MessageMarkerEntity messageMarkerEntity = new MessageMarkerLocalDataStore().getMessageMarker(messageId);
        return messageMarkerEntity != null ? messageMarkerEntity.getDeliveredCount() : 0;
    }

    @NotNull
    public final Completable saveLocalMessageMarkers(@NotNull List<? extends MessageMarkerEntity> markers) {
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        Completable completable = Completable.fromAction(() -> MessageMarkerRepository.saveLocalMessageMarkers$lambda$0(markers));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable markMessageDelivered(@NotNull String subChannel, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)subChannel, (String)"subChannel");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MarkReadRemoteDataStore().markMessageDelivered(subChannel, messageId).flatMapCompletable((Function)markMessageDelivered.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Completable markMessageRead(@NotNull String subChannel, int readToSegment) {
        Intrinsics.checkNotNullParameter((Object)subChannel, (String)"subChannel");
        Completable completable = new MarkReadRemoteDataStore().markMessageRead(subChannel, readToSegment).ignoreElement().subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Single<MessageReadUsersQueryDto> fetchMessageReadUsers(@NotNull MessageReadUsersRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new MessageMarkerRemoteDataStore().queryMessageReadUsers(request);
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityUser>> getMessageReadUsers(@NotNull String messageId, @NotNull List<? extends MessageReadMembershipFilter> memberships) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(20, 0, false, 0, 0, 0, 58, null), null, new MessageReadUsersMediator(messageId, memberships), () -> MessageMarkerRepository.getMessageReadUsers$lambda$1(messageId, memberships), new UserModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Single<MessageDeliveredUsersQueryDto> fetchMessageDeliveredUsers(@NotNull MessageDeliveredUsersRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new MessageMarkerRemoteDataStore().queryMessageDeliveredUsers(request);
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityUser>> getMessageDeliveredUsers(@NotNull String messageId, @NotNull List<? extends MessageDeliveredMembershipFilter> memberships) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(20, 0, false, 0, 0, 0, 58, null), null, new MessageDeliveredUsersMediator(messageId, memberships), () -> MessageMarkerRepository.getMessageDeliveredUsers$lambda$2(messageId, memberships), new UserModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    private static final void saveLocalMessageMarkers$lambda$0(List $markers) {
        new MessageMarkerLocalDataStore().saveLocalMessageMarkers($markers);
    }

    private static final PagingSource getMessageReadUsers$lambda$1(String $messageId, List $memberships) {
        return new MessageMarkerLocalDataStore().getMessageReadUsersPagingSource($messageId, $memberships);
    }

    private static final PagingSource getMessageDeliveredUsers$lambda$2(String $messageId, List $memberships) {
        return new MessageMarkerLocalDataStore().getMessageDeliveredUsersPagingSource($messageId, $memberships);
    }
}

