package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.core.data.reaction.paging.InvitationMediator
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity
import com.ekoapp.ekosdk.internal.keycreator.InvitationKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface InvitationPagingDao : DynamicQueryStreamPagingDao<InvitationEntity> {

    @RawQuery(observedEntities = [InvitationEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, InvitationEntity>

    fun getInvitationPagingSource(
        type: AmityInvitationType,
        target: InvitationMediator.Target
    ): PagingSource<Int, InvitationEntity> {
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "invitation",
                primaryKeyColumnName = "invitationId",
                dynamicQueryStreamKeyCreator = InvitationKeyCreator(
                    type = type,
                    target = target,
                ),
                nonce = AmityNonce.INVITATION_LIST,
                order = AmityPagingDao.Order.DESC,
                sortColumns = listOf(AmityPagingDao.Sorting.Column(
                    tableName = "invitation",
                    columnName = "createdAt",
                    order = AmityPagingDao.Order.DESC
                )),
            )
        )
    }
}