package com.amity.socialcloud.sdk.model.social.event

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityEventRSVP internal constructor(
    private val rsvpId: String = ObjectId.get().toHexString(),
    private val status: AmityEventRSVPStatus,
    private val eventId: String,
    internal var event: AmityEvent?,
    private val userId: String,
    internal var user: AmityUser?,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
    internal val path: String
) : Parcelable, ReactorObject {

    fun getRsvpId(): String {
        return rsvpId
    }

    fun getStatus(): AmityEventRSVPStatus {
        return status
    }

    fun getEventId(): String {
        return eventId
    }

    fun getEvent(): AmityEvent? {
        return event
    }

    fun getUserId(): String {
        return userId
    }

    fun getUser(): AmityUser? {
        return user
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    override fun updatedAt(): DateTime {
        return updatedAt
    }

    override fun uniqueId(): String {
        return rsvpId
    }
}
