package com.ekoapp.ekosdk.internal.usecase.event

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventRSVPStatus
import com.amity.socialcloud.sdk.social.data.event.EventRepository
import com.amity.socialcloud.sdk.social.domain.event.EventComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetMyEventsPagingDataUseCase {

    fun execute(
        status: AmityEventRSVPStatus?
    ): Flowable<PagingData<AmityEvent>> {
        return EventRepository().getMyEventsPagingData(
            status = status
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { event ->
                EventComposerUseCase().execute(event)
            }
        }
    }
}
