package com.ekoapp.ekosdk.internal.keycreator

import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType

internal class ReactionKeyCreator(
    val referenceType: AmityReactionReferenceType,
    val referenceId: String,
    val reactionName: String?
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "referenceId" to referenceId,
            "reactionName" to (reactionName ?: ""),
            "referenceType" to referenceType.value
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            referenceId = referenceId,
            referenceType = referenceType,
            reactionName = reactionName
        )
    }

    private fun getConditionStatement(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String?
    ): String {
        //reference filter
        val referenceFilterStatement = "reaction.referenceType = '${referenceType.value}'" +
                " and reaction.referenceId = '$referenceId'"
        //isDeleted filter
        var reactionNameFilterStatement = ""
        if (reactionName?.isNotEmpty() == true) {
            reactionNameFilterStatement = " and reaction.reactionName = '$reactionName'"
        }
        //compose all condition
        return referenceFilterStatement +
                reactionNameFilterStatement
    }
}