package com.amity.socialcloud.sdk.social.domain.event

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.entity.social.event.EventEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.CommunityModelMapper
import com.amity.socialcloud.sdk.social.data.event.EventLocalDataStore

internal class EventComposerUseCase : ComposerUseCase() {

    fun execute(event: AmityEvent): AmityEvent {
        addCreator(event)
        addDiscussionCommunity(event)
        addTargetCommunity(event)
        return event
    }

    private fun addCreator(event: AmityEvent) {
        event.creator = UserGetUseCase().execute(event.getUserId())
    }
    
    private fun addDiscussionCommunity(event: AmityEvent) {
        val eventEntity = EventLocalDataStore().getEvent(event.getEventId())
        eventEntity?.discussionCommunityId?.let { communityId ->
            val communityEntity = CommunityLocalDataStore().getCommunityById(communityId)
            communityEntity?.let {
                event.discussionCommunity = CommunityModelMapper().map(it)
            }
        }
    }
    
    private fun addTargetCommunity(event: AmityEvent) {
        if (event.getOriginType() == AmityEventOriginType.COMMUNITY) {
            val communityEntity = CommunityLocalDataStore().getCommunityById(event.getOriginId())
            communityEntity?.let {
                event.targetCommunity = CommunityModelMapper().map(it)
            }
        }
    }
}
