/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoUserMapper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/ekoapp/ekosdk/internal/api/mapper/EkoUserListPersister;", "Lcom/ekoapp/ekosdk/internal/api/mapper/EkoObjectPersister;", "<init>", "()V", "persist", "", "userDtoList", "", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoUserDto;", "amity-sdk_release"})
public final class EkoUserListPersister
extends EkoObjectPersister {
    @NotNull
    public static final EkoUserListPersister INSTANCE = new EkoUserListPersister();

    private EkoUserListPersister() {
    }

    @JvmStatic
    public static final void persist(@NotNull List<? extends EkoUserDto> userDtoList) {
        Intrinsics.checkNotNullParameter(userDtoList, (String)"userDtoList");
        UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(() -> EkoUserListPersister.persist$lambda$0(userDtoList, userDatabase));
    }

    private static final void persist$lambda$0(List $userDtoList, UserDatabase $userDatabase) {
        EkoObjectPersister.persistChanges($userDtoList, EkoUserMapper.Companion.getMAPPER(), $userDatabase.userDao());
        EkoUserFlagDao flagDao = $userDatabase.userFlagDao();
        for (EkoUserDto userDto : $userDtoList) {
            String string = userDto.getUserId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserId(...)");
            EkoUserFlag userFlag = new EkoUserFlag(string, null, null, 6, null);
            userFlag.setFlag(userDto.getFlag());
            EkoUserFlag diskFlag = flagDao.getByIdNow(userDto.getUserId());
            if (diskFlag != null) {
                userFlag.setLocalFlag(diskFlag.getLocalFlag());
                flagDao.update((EkoObject)userFlag);
                continue;
            }
            flagDao.insert((EkoObject)userFlag);
        }
    }
}

