/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.domain.session;

import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.LogoutProcessState;
import com.amity.socialcloud.sdk.core.data.session.SessionRepository;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JZ\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u001a\u0010\u0018\u001a\u00020\u00162\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/amity/socialcloud/sdk/core/domain/session/LoginUseCase;", "", "<init>", "()V", "execute", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "userId", "", "displayName", "authToken", "authSignature", "authSignatureExpiresAt", "Lorg/joda/time/DateTime;", "isLegacyVersion", "", "handleLoggingIn", "loginCompletable", "Lio/reactivex/rxjava3/core/Completable;", "waitForLogoutCompletion", "verifyUserId", "amity-sdk_release"})
public final class LoginUseCase {
    @NotNull
    public final Single<EkoAccount> execute(@Nullable AppEventBus appEventBus, @Nullable SessionLifeCycleEventBus sessionLifeCycleEventBus, @Nullable String userId, @Nullable String displayName, @Nullable String authToken, @Nullable String authSignature, @Nullable DateTime authSignatureExpiresAt, boolean isLegacyVersion) {
        Completable completable = userId != null ? this.verifyUserId(appEventBus, userId).andThen((CompletableSource)this.waitForLogoutCompletion()).andThen((CompletableSource)Completable.defer(() -> LoginUseCase.execute$lambda$0(appEventBus, userId, displayName, authToken, isLegacyVersion))) : Completable.defer(() -> LoginUseCase.execute$lambda$1(appEventBus, displayName, authSignature, authSignatureExpiresAt));
        Intrinsics.checkNotNull((Object)completable);
        Completable loginCompletable = completable;
        return this.handleLoggingIn(appEventBus, sessionLifeCycleEventBus, loginCompletable);
    }

    private final Single<EkoAccount> handleLoggingIn(AppEventBus appEventBus, SessionLifeCycleEventBus sessionLifeCycleEventBus, Completable loginCompletable) {
        Single single = loginCompletable.andThen((SingleSource)Single.defer(LoginUseCase::handleLoggingIn$lambda$2)).doOnSuccess(new Consumer(appEventBus, sessionLifeCycleEventBus){
            final /* synthetic */ AppEventBus $appEventBus;
            final /* synthetic */ SessionLifeCycleEventBus $sessionLifeCycleEventBus;
            {
                this.$appEventBus = $appEventBus;
                this.$sessionLifeCycleEventBus = $sessionLifeCycleEventBus;
            }

            public final void accept(EkoAccount it) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AppEventBus appEventBus = this.$appEventBus;
                    if (appEventBus != null) {
                        appEventBus.publish(AppEvent.LoginSuccess.INSTANCE);
                    }
                    SessionLifeCycleEventBus sessionLifeCycleEventBus = this.$sessionLifeCycleEventBus;
                    if (sessionLifeCycleEventBus == null) break block1;
                    sessionLifeCycleEventBus.publish(new SessionLifeCycle.Establish(it));
                }
            }
        }).doOnError(new Consumer(appEventBus){
            final /* synthetic */ AppEventBus $appEventBus;
            {
                this.$appEventBus = $appEventBus;
            }

            public final void accept(Throwable it) {
                block1: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AmityException amityError = AmityException.Companion.fromThrowable(it);
                        if (amityError.getCode() != AmityError.USER_IS_GLOBAL_BANNED.getCode() && amityError.getCode() != AmityError.UNAUTHORIZED_ERROR.getCode()) break block0;
                        AppEventBus appEventBus = this.$appEventBus;
                        if (appEventBus == null) break block1;
                        appEventBus.publish(new AppEvent.TerminationCodeReceive(amityError));
                        break block1;
                    }
                    AppEventBus appEventBus = this.$appEventBus;
                    if (appEventBus == null) break block1;
                    appEventBus.publish(AppEvent.LoginFail.INSTANCE);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"doOnError(...)");
        return single;
    }

    private final Completable waitForLogoutCompletion() {
        Completable completable = Completable.fromCallable(LoginUseCase::waitForLogoutCompletion$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromCallable(...)");
        return completable;
    }

    private final Completable verifyUserId(AppEventBus appEventBus, String userId) {
        Completable completable = Completable.fromCallable(() -> LoginUseCase.verifyUserId$lambda$4(userId, appEventBus));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromCallable(...)");
        return completable;
    }

    private static final CompletableSource execute$lambda$0(AppEventBus $appEventBus, String $userId, String $displayName, String $authToken, boolean $isLegacyVersion) {
        block0: {
            AppEventBus appEventBus = $appEventBus;
            if (appEventBus == null) break block0;
            appEventBus.publish(AppEvent.LoggingIn.INSTANCE);
        }
        return (CompletableSource)new SessionRepository().login($userId, $displayName, $authToken, $isLegacyVersion);
    }

    private static final CompletableSource execute$lambda$1(AppEventBus $appEventBus, String $displayName, String $authSignature, DateTime $authSignatureExpiresAt) {
        block0: {
            AppEventBus appEventBus = $appEventBus;
            if (appEventBus == null) break block0;
            appEventBus.publish(AppEvent.LoggingIn.INSTANCE);
        }
        return (CompletableSource)new SessionRepository().loginVisitor($displayName, $authSignature, $authSignatureExpiresAt);
    }

    private static final SingleSource handleLoggingIn$lambda$2() {
        return (SingleSource)new SessionRepository().getCurrentAccount();
    }

    private static final Unit waitForLogoutCompletion$lambda$3() {
        while (CoreClient.INSTANCE.getLogoutProcessState$amity_sdk_release() == LogoutProcessState.LOGGING_OUT) {
            Thread.sleep(80L);
        }
        return Unit.INSTANCE;
    }

    private static final Unit verifyUserId$lambda$4(String $userId, AppEventBus $appEventBus) {
        block1: {
            String currentUserId = new ActiveUserIdGetUseCase().execute();
            if (!(((CharSequence)currentUserId).length() > 0) || Intrinsics.areEqual((Object)$userId, (Object)currentUserId)) break block1;
            AppEventBus appEventBus = $appEventBus;
            if (appEventBus != null) {
                appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
            }
        }
        return Unit.INSTANCE;
    }
}

