/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.chat.message;

import android.net.Uri;
import com.amity.socialcloud.sdk.api.chat.message.create.AmityAudioMessageCreator;
import com.amity.socialcloud.sdk.api.chat.message.create.AmityCustomMessageCreator;
import com.amity.socialcloud.sdk.api.chat.message.create.AmityFileMessageCreator;
import com.amity.socialcloud.sdk.api.chat.message.create.AmityImageMessageCreator;
import com.amity.socialcloud.sdk.api.chat.message.create.AmityMessageCreationTarget;
import com.amity.socialcloud.sdk.api.chat.message.create.AmityTextMessageCreator;
import com.amity.socialcloud.sdk.api.chat.message.create.AmityVideoMessageCreator;
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuery;
import com.amity.socialcloud.sdk.api.chat.message.update.AmityCustomTextMessageUpdate;
import com.amity.socialcloud.sdk.api.chat.message.update.AmityTextMessageUpdate;
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment;
import com.amity.socialcloud.sdk.model.core.flag.AmityContentFlagReason;
import com.ekoapp.ekosdk.internal.usecase.message.FlagMessageUseCase;
import com.ekoapp.ekosdk.internal.usecase.message.MessageDeleteUseCase;
import com.ekoapp.ekosdk.internal.usecase.message.MessageLiveObjectUseCase;
import com.ekoapp.ekosdk.internal.usecase.message.UnFlagMessageUseCase;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0012H\u0007J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0012H\u0007J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0012H\u0007J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010(\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0016\u0010(\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010,\u001a\u00020'\u00a8\u0006-"}, d2={"Lcom/amity/socialcloud/sdk/api/chat/message/AmityMessageRepository;", "", "<init>", "()V", "getMessages", "Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuery$Builder;", "subChannelId", "", "getMessage", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage;", "messageId", "createTextMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/create/AmityTextMessageCreator$Builder;", "text", "createImageMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/create/AmityImageMessageCreator$Builder;", "imageUri", "Landroid/net/Uri;", "attachment", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessageAttachment;", "createFileMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/create/AmityFileMessageCreator$Builder;", "fileUri", "createVideoMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/create/AmityVideoMessageCreator$Builder;", "videoUri", "createAudioMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/create/AmityAudioMessageCreator$Builder;", "audioUri", "createCustomMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/create/AmityCustomMessageCreator$Builder;", "data", "Lcom/google/gson/JsonObject;", "editTextMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/update/AmityTextMessageUpdate$Builder;", "editCustomMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/update/AmityCustomTextMessageUpdate$Builder;", "softDeleteMessage", "Lio/reactivex/rxjava3/core/Completable;", "flagMessage", "reason", "Lcom/amity/socialcloud/sdk/model/core/flag/AmityContentFlagReason;", "unflagMessage", "deleteFailedMessages", "amity-sdk_release"})
public final class AmityMessageRepository {
    @NotNull
    public final AmityMessageQuery.Builder getMessages(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new AmityMessageQuery.Builder(subChannelId);
    }

    @NotNull
    public final Flowable<AmityMessage> getMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new MessageLiveObjectUseCase().execute(messageId);
    }

    @NotNull
    public final AmityTextMessageCreator.Builder createTextMessage(@NotNull String subChannelId, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().text(text);
    }

    @Deprecated(message="This function is deprecated, please use AmityChatClient.newMessageRepository().createImageMessage(subChannelId: String, attachment: AmityMessageAttachment) instead", replaceWith=@ReplaceWith(expression="AmityChatClient.newMessageRepository().createImageMessage(subChannelId: String, attachment: AmityMessageAttachment)", imports={"com.amity.socialcloud.sdk.api.chat.message.AmityMessageRepository"}))
    @NotNull
    public final AmityImageMessageCreator.Builder createImageMessage(@NotNull String subChannelId, @NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().image(new AmityMessageAttachment.URL(imageUri));
    }

    @NotNull
    public final AmityImageMessageCreator.Builder createImageMessage(@NotNull String subChannelId, @NotNull AmityMessageAttachment attachment) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().image(attachment);
    }

    @Deprecated(message="This function is deprecated, please use AmityChatClient.newMessageRepository().createFileMessage(subChannelId: String, attachment: AmityMessageAttachment) instead", replaceWith=@ReplaceWith(expression="AmityChatClient.newMessageRepository().createFileMessage(subChannelId: String, attachment: AmityMessageAttachment)", imports={"com.amity.socialcloud.sdk.api.chat.message.AmityMessageRepository"}))
    @NotNull
    public final AmityFileMessageCreator.Builder createFileMessage(@NotNull String subChannelId, @NotNull Uri fileUri) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().file(new AmityMessageAttachment.URL(fileUri));
    }

    @NotNull
    public final AmityFileMessageCreator.Builder createFileMessage(@NotNull String subChannelId, @NotNull AmityMessageAttachment attachment) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().file(attachment);
    }

    @Deprecated(message="This function is deprecated, please use AmityChatClient.newMessageRepository().createVideoMessage(subChannelId: String, attachment: AmityMessageAttachment) instead", replaceWith=@ReplaceWith(expression="AmityChatClient.newMessageRepository().createVideoMessage(subChannelId: String, attachment: AmityMessageAttachment)", imports={"com.amity.socialcloud.sdk.api.chat.message.AmityMessageRepository"}))
    @NotNull
    public final AmityVideoMessageCreator.Builder createVideoMessage(@NotNull String subChannelId, @NotNull Uri videoUri) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)videoUri, (String)"videoUri");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().video(new AmityMessageAttachment.URL(videoUri));
    }

    @NotNull
    public final AmityVideoMessageCreator.Builder createVideoMessage(@NotNull String subChannelId, @NotNull AmityMessageAttachment attachment) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().video(attachment);
    }

    @Deprecated(message="This function is deprecated, please use AmityChatClient.newMessageRepository().createAudioMessage(subChannelId: String, attachment: AmityMessageAttachment) instead", replaceWith=@ReplaceWith(expression="AmityChatClient.newMessageRepository().createAudioMessage(subChannelId: String, attachment: AmityMessageAttachment)", imports={"com.amity.socialcloud.sdk.api.chat.message.AmityMessageRepository"}))
    @NotNull
    public final AmityAudioMessageCreator.Builder createAudioMessage(@NotNull String subChannelId, @NotNull Uri audioUri) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)audioUri, (String)"audioUri");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().audio(new AmityMessageAttachment.URL(audioUri));
    }

    @NotNull
    public final AmityAudioMessageCreator.Builder createAudioMessage(@NotNull String subChannelId, @NotNull AmityMessageAttachment attachment) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().audio(attachment);
    }

    @NotNull
    public final AmityCustomMessageCreator.Builder createCustomMessage(@NotNull String subChannelId, @NotNull JsonObject data) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new AmityMessageCreationTarget.Builder(subChannelId).with().custom(data);
    }

    @NotNull
    public final AmityTextMessageUpdate.Builder editTextMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new AmityTextMessageUpdate.Builder(messageId);
    }

    @NotNull
    public final AmityCustomTextMessageUpdate.Builder editCustomMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new AmityCustomTextMessageUpdate.Builder(messageId);
    }

    @NotNull
    public final Completable softDeleteMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new MessageDeleteUseCase().execute(messageId);
    }

    @Deprecated(message="This function is deprecated, please use AmityChatClient.newMessageRepository().flagMessage(messageId: String, reason: AmityContentFlagReason) instead", replaceWith=@ReplaceWith(expression="AmityChatClient.newMessageRepository().flagMessage(messageId: String, reason: AmityContentFlagReason)", imports={"com.amity.socialcloud.sdk.api.chat.message.AmityMessageRepository"}))
    @NotNull
    public final Completable flagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return this.flagMessage(messageId, new AmityContentFlagReason.Others(""));
    }

    @NotNull
    public final Completable flagMessage(@NotNull String messageId, @NotNull AmityContentFlagReason reason) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return new FlagMessageUseCase().execute(messageId, reason);
    }

    @NotNull
    public final Completable unflagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new UnFlagMessageUseCase().execute(messageId);
    }

    @NotNull
    public final Completable deleteFailedMessages() {
        return new MessageRepository().deleteFailedMessages();
    }
}

