/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoChannelReadStatusTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoChannelExtraDao_Impl
extends EkoChannelExtraDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoChannelExtra> __insertAdapterOfEkoChannelExtra;
    private final EkoChannelReadStatusTypeConverter __ekoChannelReadStatusTypeConverter = new EkoChannelReadStatusTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoChannelExtra> __deleteAdapterOfEkoChannelExtra;
    private final EntityDeleteOrUpdateAdapter<EkoChannelExtra> __updateAdapterOfEkoChannelExtra;

    public EkoChannelExtraDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoChannelExtra = new EntityInsertAdapter<EkoChannelExtra>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `channel_extra` (`channelId`,`readStatus`,`localReadToSegment`,`localLastMentionedSegment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoChannelExtra entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                String _tmp = EkoChannelExtraDao_Impl.this.__ekoChannelReadStatusTypeConverter.readStatusToString(entity.getReadStatus());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                statement.bindLong(3, (long)entity.getLocalReadToSegment());
                statement.bindLong(4, (long)entity.getLocalLastMentionedSegment());
                String _tmp_1 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                String _tmp_3 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_3);
                }
            }
        };
        this.__deleteAdapterOfEkoChannelExtra = new EntityDeleteOrUpdateAdapter<EkoChannelExtra>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `channel_extra` WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoChannelExtra entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
            }
        };
        this.__updateAdapterOfEkoChannelExtra = new EntityDeleteOrUpdateAdapter<EkoChannelExtra>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `channel_extra` SET `channelId` = ?,`readStatus` = ?,`localReadToSegment` = ?,`localLastMentionedSegment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoChannelExtra entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                String _tmp = EkoChannelExtraDao_Impl.this.__ekoChannelReadStatusTypeConverter.readStatusToString(entity.getReadStatus());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                statement.bindLong(3, (long)entity.getLocalReadToSegment());
                statement.bindLong(4, (long)entity.getLocalLastMentionedSegment());
                String _tmp_1 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                String _tmp_3 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_3);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoChannelExtra object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoChannelExtra.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoChannelExtra> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoChannelExtra.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoChannelExtra object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoChannelExtra.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoChannelExtra> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoChannelExtra.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoChannelExtra object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoChannelExtra.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoChannelExtra object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelExtraDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoChannelExtra> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelExtraDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoChannelExtra object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelExtraDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insertOrUpdate(String id) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelExtraDao_Impl.super.insertOrUpdate(id);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insertOrUpdate(List<String> ids) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelExtraDao_Impl.super.insertOrUpdate(ids);
            return Unit.INSTANCE;
        });
    }

    @Override
    public EkoChannelExtra getByIdNow(String id) {
        String _sql = "SELECT * from channel_extra where channelId = ? LIMIT 1";
        return (EkoChannelExtra)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_extra where channelId = ? LIMIT 1");){
                EkoChannelExtra _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfReadStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readStatus");
                int _columnIndexOfLocalReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localReadToSegment");
                int _columnIndexOfLocalLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastMentionedSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result = new EkoChannelExtra(_tmpChannelId);
                    String _tmp = _stmt.isNull(_columnIndexOfReadStatus) ? null : _stmt.getText(_columnIndexOfReadStatus);
                    EkoChannelReadStatus _tmpReadStatus = this.__ekoChannelReadStatusTypeConverter.stringToReadStatus(_tmp);
                    _result.setReadStatus(_tmpReadStatus);
                    int _tmpLocalReadToSegment = (int)_stmt.getLong(_columnIndexOfLocalReadToSegment);
                    _result.setLocalReadToSegment(_tmpLocalReadToSegment);
                    int _tmpLocalLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLocalLastMentionedSegment);
                    _result.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoChannelExtra ekoChannelExtra = _result;
                return ekoChannelExtra;
            }
        });
    }

    @Override
    public Flowable<EkoChannelExtra> getById(String id) {
        String _sql = "SELECT * from channel_extra where channelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_extra"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_extra where channelId = ? LIMIT 1");){
                EkoChannelExtra _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfReadStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readStatus");
                int _columnIndexOfLocalReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localReadToSegment");
                int _columnIndexOfLocalLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastMentionedSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result = new EkoChannelExtra(_tmpChannelId);
                    String _tmp = _stmt.isNull(_columnIndexOfReadStatus) ? null : _stmt.getText(_columnIndexOfReadStatus);
                    EkoChannelReadStatus _tmpReadStatus = this.__ekoChannelReadStatusTypeConverter.stringToReadStatus(_tmp);
                    _result.setReadStatus(_tmpReadStatus);
                    int _tmpLocalReadToSegment = (int)_stmt.getLong(_columnIndexOfLocalReadToSegment);
                    _result.setLocalReadToSegment(_tmpLocalReadToSegment);
                    int _tmpLocalLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLocalLastMentionedSegment);
                    _result.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoChannelExtra ekoChannelExtra = _result;
                return ekoChannelExtra;
            }
        });
    }

    @Override
    public Single<List<String>> getAllIdsByReadStatus(EkoChannelReadStatus readStatus) {
        String _sql = "SELECT channelId from channel_extra where readStatus = ?";
        return RxRoom.createSingle((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT channelId from channel_extra where readStatus = ?");){
                int _argIndex = 1;
                String _tmp = this.__ekoChannelReadStatusTypeConverter.readStatusToString(readStatus);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                ArrayList<String> _result = new ArrayList<String>();
                while (_stmt.step()) {
                    String _item = _stmt.isNull(0) ? null : _stmt.getText(0);
                    _result.add(_item);
                }
                ArrayList<String> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from channel_extra";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_extra");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateAllReadStatuses(EkoChannelReadStatus status) {
        String _sql = "UPDATE channel_extra set readStatus = ? where readStatus != ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_extra set readStatus = ? where readStatus != ?");){
                int _argIndex = 1;
                String _tmp = this.__ekoChannelReadStatusTypeConverter.readStatusToString(status);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = this.__ekoChannelReadStatusTypeConverter.readStatusToString(status);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_1);
                }
                _stmt.step();
                Object var7_7 = null;
                return var7_7;
            }
        });
    }

    @Override
    public void updateReadStatus(String id, EkoChannelReadStatus readMode) {
        String _sql = "UPDATE channel_extra set readStatus = ? where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_extra set readStatus = ? where channelId = ?");){
                int _argIndex = 1;
                String _tmp = this.__ekoChannelReadStatusTypeConverter.readStatusToString(readMode);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                _stmt.step();
                Object var7_7 = null;
                return var7_7;
            }
        });
    }

    @Override
    public void updateLocalReadToSegment(String channelId, int localReadToSegment) {
        String _sql = "UPDATE channel_extra set localReadToSegment = ? where channelId = ? and localReadToSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_extra set localReadToSegment = ? where channelId = ? and localReadToSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)localReadToSegment);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)localReadToSegment);
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateLocalLastMentionedSegment(String channelId, int localLastMentionedSegment) {
        String _sql = "UPDATE channel_extra set localLastMentionedSegment = ? where channelId = ? and localLastMentionedSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_extra set localLastMentionedSegment = ? where channelId = ? and localLastMentionedSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)localLastMentionedSegment);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)localLastMentionedSegment);
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void deleteAllFromChannel(String channelId) {
        String _sql = "DELETE from channel_extra where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_extra where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

